/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.fusionReactor;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileEntityFusionController
extends TilePowerAcceptor
implements IInventoryProvider,
IContainerProvider {
    public Inventory inventory = new Inventory(3, "TileEntityFusionController", 64, (TileEntity)this);
    public int coilStatus = 0;
    public int crafingTickTime = 0;
    public int finalTickTime = 0;
    public int neededPower = 0;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    FusionReactorRecipe currentRecipe = null;
    boolean hasStartedCrafting = false;

    public TileEntityFusionController() {
        super(4);
    }

    public double getMaxPower() {
        return 1.0E8;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return direction != EnumFacing.DOWN && direction != EnumFacing.UP;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return direction == EnumFacing.DOWN || direction == EnumFacing.UP;
    }

    public double getMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0.0;
        }
        return 1000000.0;
    }

    public double getMaxInput() {
        if (this.hasStartedCrafting) {
            return 0.0;
        }
        return 8192.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.crafingTickTime = tagCompound.getInteger("crafingTickTime");
        this.finalTickTime = tagCompound.getInteger("finalTickTime");
        this.neededPower = tagCompound.getInteger("neededPower");
        this.hasStartedCrafting = tagCompound.getBoolean("hasStartedCrafting");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        if (this.crafingTickTime == -1) {
            this.crafingTickTime = 0;
        }
        if (this.finalTickTime == -1) {
            this.finalTickTime = 0;
        }
        if (this.neededPower == -1) {
            this.neededPower = 0;
        }
        tagCompound.setInteger("crafingTickTime", this.crafingTickTime);
        tagCompound.setInteger("finalTickTime", this.finalTickTime);
        tagCompound.setInteger("neededPower", this.neededPower);
        tagCompound.setBoolean("hasStartedCrafting", this.hasStartedCrafting);
        return tagCompound;
    }

    public boolean checkCoils() {
        if (this.isCoil(this.getPos().getX() + 3, this.getPos().getY(), this.getPos().getZ() + 1) && this.isCoil(this.getPos().getX() + 3, this.getPos().getY(), this.getPos().getZ()) && this.isCoil(this.getPos().getX() + 3, this.getPos().getY(), this.getPos().getZ() - 1) && this.isCoil(this.getPos().getX() - 3, this.getPos().getY(), this.getPos().getZ() + 1) && this.isCoil(this.getPos().getX() - 3, this.getPos().getY(), this.getPos().getZ()) && this.isCoil(this.getPos().getX() - 3, this.getPos().getY(), this.getPos().getZ() - 1) && this.isCoil(this.getPos().getX() + 2, this.getPos().getY(), this.getPos().getZ() + 2) && this.isCoil(this.getPos().getX() + 2, this.getPos().getY(), this.getPos().getZ() + 1) && this.isCoil(this.getPos().getX() + 2, this.getPos().getY(), this.getPos().getZ() - 1) && this.isCoil(this.getPos().getX() + 2, this.getPos().getY(), this.getPos().getZ() - 2) && this.isCoil(this.getPos().getX() - 2, this.getPos().getY(), this.getPos().getZ() + 2) && this.isCoil(this.getPos().getX() - 2, this.getPos().getY(), this.getPos().getZ() + 1) && this.isCoil(this.getPos().getX() - 2, this.getPos().getY(), this.getPos().getZ() - 1) && this.isCoil(this.getPos().getX() - 2, this.getPos().getY(), this.getPos().getZ() - 2) && this.isCoil(this.getPos().getX() + 1, this.getPos().getY(), this.getPos().getZ() + 3) && this.isCoil(this.getPos().getX() + 1, this.getPos().getY(), this.getPos().getZ() + 2) && this.isCoil(this.getPos().getX() + 1, this.getPos().getY(), this.getPos().getZ() - 2) && this.isCoil(this.getPos().getX() + 1, this.getPos().getY(), this.getPos().getZ() - 3) && this.isCoil(this.getPos().getX() - 1, this.getPos().getY(), this.getPos().getZ() + 3) && this.isCoil(this.getPos().getX() - 1, this.getPos().getY(), this.getPos().getZ() + 2) && this.isCoil(this.getPos().getX() - 1, this.getPos().getY(), this.getPos().getZ() - 2) && this.isCoil(this.getPos().getX() - 1, this.getPos().getY(), this.getPos().getZ() - 3) && this.isCoil(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ() + 3) && this.isCoil(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ() - 3)) {
            this.coilStatus = 1;
            return true;
        }
        this.coilStatus = 0;
        return false;
    }

    private boolean isCoil(int x, int y, int z) {
        return this.world.getBlockState(new BlockPos(x, y, z)).getBlock() == ModBlocks.FUSION_COIL;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.world.getTotalWorldTime() % 20L == 0L) {
            this.checkCoils();
        }
        if (!this.world.isRemote) {
            if (this.coilStatus == 1) {
                if (this.currentRecipe == null) {
                    if (this.inventory.hasChanged || this.crafingTickTime != 0) {
                        for (FusionReactorRecipe reactorRecipe : FusionReactorRecipeHelper.reactorRecipes) {
                            if (!ItemUtils.isItemEqual((ItemStack)this.getStackInSlot(this.topStackSlot), (ItemStack)reactorRecipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) continue;
                            if (reactorRecipe.getBottomInput() == null || ItemUtils.isItemEqual((ItemStack)this.getStackInSlot(this.bottomStackSlot), (ItemStack)reactorRecipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                                if (!this.canFitStack(reactorRecipe.getOutput(), this.outputStackSlot, true)) continue;
                                this.currentRecipe = reactorRecipe;
                                if (this.crafingTickTime != 0) {
                                    this.finalTickTime = this.currentRecipe.getTickTime();
                                    this.neededPower = (int)this.currentRecipe.getStartEU();
                                }
                                this.hasStartedCrafting = false;
                                this.crafingTickTime = 0;
                                this.finalTickTime = this.currentRecipe.getTickTime();
                                this.neededPower = (int)this.currentRecipe.getStartEU();
                            }
                            break;
                        }
                    }
                } else {
                    if (this.inventory.hasChanged && !this.validateRecipe()) {
                        this.resetCrafter();
                        return;
                    }
                    if (!this.hasStartedCrafting) {
                        if (this.canUseEnergy(this.currentRecipe.getStartEU() + 64.0)) {
                            this.useEnergy(this.currentRecipe.getStartEU());
                            this.hasStartedCrafting = true;
                        }
                    } else if (this.crafingTickTime < this.currentRecipe.getTickTime()) {
                        if (this.currentRecipe.getEuTick() > 0.0) {
                            this.addEnergy(this.currentRecipe.getEuTick());
                            ++this.crafingTickTime;
                        } else if (this.canUseEnergy(this.currentRecipe.getEuTick() * -1.0)) {
                            this.setEnergy(this.getEnergy() - this.currentRecipe.getEuTick() * -1.0);
                            ++this.crafingTickTime;
                        }
                    } else if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                        if (this.getStackInSlot(this.outputStackSlot) == null) {
                            this.setInventorySlotContents(this.outputStackSlot, this.currentRecipe.getOutput().copy());
                        } else {
                            this.decrStackSize(this.outputStackSlot, -this.currentRecipe.getOutput().stackSize);
                        }
                        this.decrStackSize(this.topStackSlot, this.currentRecipe.getTopInput().stackSize);
                        if (this.currentRecipe.getBottomInput() != null) {
                            this.decrStackSize(this.bottomStackSlot, this.currentRecipe.getBottomInput().stackSize);
                        }
                        this.resetCrafter();
                    }
                }
            } else if (this.currentRecipe != null) {
                this.resetCrafter();
            }
        }
        if (this.inventory.hasChanged) {
            this.inventory.hasChanged = false;
        }
    }

    private boolean validateRecipe() {
        if (ItemUtils.isItemEqual((ItemStack)this.getStackInSlot(this.topStackSlot), (ItemStack)this.currentRecipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) {
            if (this.currentRecipe.getBottomInput() != null && !ItemUtils.isItemEqual((ItemStack)this.getStackInSlot(this.bottomStackSlot), (ItemStack)this.currentRecipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                return false;
            }
            if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                return true;
            }
        }
        return false;
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.crafingTickTime = -1;
        this.finalTickTime = -1;
        this.neededPower = -1;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack == null) {
            return true;
        }
        if (this.inventory.getStackInSlot(slot) == null) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)this.inventory.getStackInSlot(slot), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)oreDic) && stack.stackSize + this.inventory.getStackInSlot((int)slot).stackSize <= stack.getMaxStackSize();
    }

    public String getName() {
        return null;
    }

    public boolean hasCustomName() {
        return false;
    }

    public ITextComponent getDisplayName() {
        return null;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getCoilStatus() {
        return this.coilStatus;
    }

    public void setCoilStatus(int coilStatus) {
        this.coilStatus = coilStatus;
    }

    public int getCrafingTickTime() {
        return this.crafingTickTime;
    }

    public void setCrafingTickTime(int crafingTickTime) {
        this.crafingTickTime = crafingTickTime;
    }

    public int getFinalTickTime() {
        return this.finalTickTime;
    }

    public void setFinalTickTime(int finalTickTime) {
        this.finalTickTime = finalTickTime;
    }

    public int getNeededPower() {
        return this.neededPower;
    }

    public void setNeededPower(int neededPower) {
        this.neededPower = neededPower;
    }

    public int getProgressScaled() {
        return Math.max(0, Math.min(24, (this.getCrafingTickTime() > 0 ? 1 : 0) + this.getCrafingTickTime() * 24 / (this.finalTickTime < 1 ? 1 : this.finalTickTime)));
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("fusionreactor").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).slot(0, 88, 17).slot(1, 88, 53).outputSlot(2, 148, 35).syncEnergyValue().syncIntegerValue(this::getCoilStatus, this::setCoilStatus).syncIntegerValue(this::getCrafingTickTime, this::setCrafingTickTime).syncIntegerValue(this::getFinalTickTime, this::setFinalTickTime).syncIntegerValue(this::getNeededPower, this::setNeededPower).addInventory().create();
    }
}

