/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;

public abstract class TileBaseFluidGenerator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider {
    private final FluidGeneratorRecipeList recipes;
    private final int euTick;
    public final Tank tank;
    public final Inventory inventory;
    double pendingWithdraw = 0.0;
    protected long lastOutput = 0L;

    public TileBaseFluidGenerator(EFluidGenerator type, int tier, String tileName, int tankCapacity, int euTick) {
        super(tier);
        this.recipes = GeneratorRecipeHelper.getFluidRecipesForGenerator(type);
        this.tank = new Tank(tileName, tankCapacity, (TileEntity)this);
        this.inventory = new Inventory(3, tileName, 64, (TileEntity)this);
        this.euTick = euTick;
    }

    public TileBaseFluidGenerator(EFluidGenerator type, EnumPowerTier tier, String tileName, int tankCapacity, int euTick) {
        this(type, tier.ordinal(), tileName, tankCapacity, euTick);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.world.isRemote && (this.acceptFluid() && FluidUtils.drainContainers((FluidTank)this.tank, (IInventory)this.inventory, (int)0, (int)1) || FluidUtils.fillContainers((FluidTank)this.tank, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType()))) {
            this.syncWithAll();
        }
        if (this.tank.getFluidAmount() > 0) {
            this.getRecipes().getRecipeForFluid(this.tank.getFluidType()).ifPresent(recipe -> {
                if (this.tryAddingEnergy(this.euTick)) {
                    Integer euPerBucket = recipe.getEnergyPerMb() * 1000;
                    float millibucketsPerTick = 16000.0f / (float)euPerBucket.intValue();
                    this.pendingWithdraw += (double)millibucketsPerTick;
                    int currentWithdraw = (int)this.pendingWithdraw;
                    this.pendingWithdraw -= (double)currentWithdraw;
                    this.tank.drain(currentWithdraw, true);
                    this.lastOutput = this.world.getTotalWorldTime();
                }
            });
        }
        if (this.tank.getFluidType() != null && this.getStackInSlot(2) == null) {
            this.inventory.setInventorySlotContents(2, new ItemStack(this.tank.getFluidType().getBlock()));
        } else if (this.tank.getFluidType() == null && this.getStackInSlot(2) != null) {
            this.setInventorySlotContents(2, null);
        }
        if (!this.world.isRemote) {
            if (this.world.getTotalWorldTime() - this.lastOutput < 30L && !this.isActive()) {
                this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.world.getTotalWorldTime() - this.lastOutput > 30L && this.isActive()) {
                this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    protected boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    protected boolean acceptFluid() {
        FluidStack stack;
        if (this.getStackInSlot(0) != null && (stack = FluidUtils.getFluidStackInContainer((ItemStack)this.getStackInSlot(0))) != null) {
            return this.recipes.getRecipeForFluid(stack.getFluid()).isPresent();
        }
        return false;
    }

    public FluidGeneratorRecipeList getRecipes() {
        return this.recipes;
    }

    public double getMaxOutput() {
        return this.euTick;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.values()[this.tier];
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.world.markBlockRangeForRenderUpdate(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
        this.readFromNBT(packet.getNbtCompound());
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }
}

