/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileDragonEggSiphoner
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider {
    public static final int euTick = ConfigTechReborn.DragonEggSiphonerOutput;
    public Inventory inventory = new Inventory(3, "TileAlloySmelter", 64, (TileEntity)this);
    private long lastOutput = 0L;

    public TileDragonEggSiphoner() {
        super(2);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.world.isRemote) {
            if (this.world.getBlockState(new BlockPos(this.getPos().getX(), this.getPos().getY() + 1, this.getPos().getZ())).getBlock() == Blocks.DRAGON_EGG && this.tryAddingEnergy(euTick)) {
                this.lastOutput = this.world.getTotalWorldTime();
            }
            if (this.world.getTotalWorldTime() - this.lastOutput < 30L && !this.isActive()) {
                this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.world.getTotalWorldTime() - this.lastOutput > 30L && this.isActive()) {
                this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.DRAGON_EGG_SIPHONER, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public double getMaxPower() {
        return 1000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return euTick;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.HIGH;
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

