/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.ForgeModContainer;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileGenerator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public static int outputAmount = 10;
    public Inventory inventory = new Inventory(2, "TileGenerator", 64, (TileEntity)this);
    public int fuelSlot = 0;
    public int burnTime;
    public int totalBurnTime = 0;
    public boolean isBurning;
    public boolean lastTickBurning;
    ItemStack burnItem;

    public TileGenerator() {
        super(1);
    }

    public static int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)stack) / 4;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.world.isRemote) {
            return;
        }
        if (this.getEnergy() < this.getMaxPower()) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.addEnergy(outputAmount);
                this.isBurning = true;
            }
        } else {
            this.isBurning = false;
        }
        if (this.burnTime == 0) {
            this.updateState();
            this.burnTime = this.totalBurnTime = TileGenerator.getItemBurnTime(this.getStackInSlot(this.fuelSlot));
            if (this.burnTime > 0) {
                this.updateState();
                this.burnItem = this.getStackInSlot(this.fuelSlot);
                if (this.getStackInSlot((int)this.fuelSlot).stackSize == 1) {
                    if (this.getStackInSlot(this.fuelSlot).getItem() == Items.LAVA_BUCKET || this.getStackInSlot(this.fuelSlot).getItem() == ForgeModContainer.getInstance().universalBucket) {
                        this.setInventorySlotContents(this.fuelSlot, new ItemStack(Items.BUCKET));
                    } else {
                        this.setInventorySlotContents(this.fuelSlot, null);
                    }
                } else {
                    this.decrStackSize(this.fuelSlot, 1);
                }
            }
        }
        this.lastTickBurning = this.isBurning;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
        if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
            if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.burnTime > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.burnTime > 0), this.world, this.pos);
            }
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 64.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public ItemStack getWrenchDrop(EntityPlayer p0) {
        return new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("generator").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).fuelSlot(0, 80, 54).energySlot(1, 8, 72).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create();
    }
}

