/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileHeatGenerator
extends TilePowerAcceptor
implements IWrenchable {
    public static final int euTick = ConfigTechReborn.HeatGeneratorOutput;
    private long lastOutput = 0L;

    public TileHeatGenerator() {
        super(1);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.world.isRemote) {
            for (EnumFacing direction : EnumFacing.values()) {
                if (direction.equals((Object)EnumFacing.UP) || this.world.getBlockState(new BlockPos(this.getPos().getX() + direction.getFrontOffsetX(), this.getPos().getY() + direction.getFrontOffsetY(), this.getPos().getZ() + direction.getFrontOffsetZ())).getBlock() != Blocks.LAVA || !this.tryAddingEnergy(euTick)) continue;
                this.lastOutput = this.world.getTotalWorldTime();
            }
            if (this.world.getTotalWorldTime() - this.lastOutput < 30L && !this.isActive()) {
                this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.world.getTotalWorldTime() - this.lastOutput > 30L && this.isActive()) {
                this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.HEAT_GENERATOR, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 64.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }
}

