/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.config.ConfigTechReborn;

public class TileLightningRod
extends TilePowerAcceptor {
    private int onStatusHoldTicks = -1;

    public TileLightningRod() {
        super(2);
    }

    public void update() {
        float lightStrikeChance;
        float totalChance;
        float weatherStrength;
        super.update();
        if (this.onStatusHoldTicks > 0) {
            --this.onStatusHoldTicks;
        }
        if (this.onStatusHoldTicks == 0 || this.getEnergy() <= 0.0) {
            if (this.getBlockType() instanceof BlockMachineBase) {
                ((BlockMachineBase)this.getBlockType()).setActive(Boolean.valueOf(false), this.world, this.pos);
            }
            this.onStatusHoldTicks = -1;
        }
        if ((weatherStrength = this.world.getThunderStrength(1.0f)) > 0.2f && this.world.rand.nextInt((int)Math.floor(totalChance = (lightStrikeChance = (100.0f - (float)ConfigTechReborn.LightningRodChance) * 20.0f) * this.getLightningStrikeMultiplier() * (1.1f - weatherStrength))) == 0) {
            EntityLightningBolt lightningBolt = new EntityLightningBolt(this.world, (double)((float)this.pos.getX() + 0.5f), (double)this.world.provider.getAverageGroundLevel(), (double)((float)this.pos.getZ() + 0.5f), false);
            this.world.addWeatherEffect((Entity)lightningBolt);
            this.world.spawnEntity((Entity)lightningBolt);
            this.addEnergy(32768.0f * (0.3f + weatherStrength));
            ((BlockMachineBase)this.getBlockType()).setActive(Boolean.valueOf(true), this.world, this.pos);
            this.onStatusHoldTicks = 400;
        }
    }

    public float getLightningStrikeMultiplier() {
        float actualHeight = this.world.provider.getActualHeight();
        float groundLevel = this.world.provider.getAverageGroundLevel();
        int i = this.pos.getY() + 1;
        while ((float)i < actualHeight) {
            if (!this.isValidIronFence(i)) {
                if (groundLevel >= (float)i) {
                    return 4.3f;
                }
                float max = actualHeight - groundLevel;
                float got = (float)i - groundLevel;
                return 1.2f - got / max;
            }
            ++i;
        }
        return 4.0f;
    }

    public boolean isValidIronFence(int y) {
        Item itemBlock = Item.getItemFromBlock((Block)this.world.getBlockState(new BlockPos(this.pos.getX(), y, this.pos.getZ())).getBlock());
        for (ItemStack fence : OreDictionary.getOres((String)"fenceIron")) {
            if (fence.getItem() != itemBlock) continue;
            return true;
        }
        return false;
    }

    public double getMaxPower() {
        return 327680.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return direction == this.getFacingEnum();
    }

    public double getMaxOutput() {
        return 2048.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.HIGH;
    }
}

