/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.blocks.generator.BlockSolarPanel;

public class TileSolarPanel
extends TilePowerAcceptor
implements ITickable {
    boolean shouldMakePower = false;
    boolean lastTickSate = false;
    int powerToAdd;

    public TileSolarPanel() {
        super(1);
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.world.isRemote) {
            if (this.world.getTotalWorldTime() % 60L == 0L) {
                this.shouldMakePower = this.isSunOut();
            }
            if (this.shouldMakePower) {
                this.powerToAdd = 10;
                this.addEnergy(this.powerToAdd);
            } else {
                this.powerToAdd = 0;
            }
            this.world.setBlockState(this.getPos(), this.world.getBlockState(this.getPos()).withProperty((IProperty)BlockSolarPanel.ACTIVE, (Comparable)Boolean.valueOf(this.isSunOut())));
        }
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        super.addInfo(info, isRealTile);
        if (isRealTile) {
            // empty if block
        }
    }

    public boolean isSunOut() {
        return this.world.canBlockSeeSky(this.pos.up()) && !this.world.isRaining() && !this.world.isThundering() && this.world.isDaytime();
    }

    public double getMaxPower() {
        return 1000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 32.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }
}

