/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;

public class TileWaterMill
extends TilePowerAcceptor {
    int waterblocks = 0;

    public TileWaterMill() {
        super(1);
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.world.getTotalWorldTime() % 20L == 0L) {
            this.checkForWater();
        }
        if (this.waterblocks > 0) {
            this.addEnergy(this.waterblocks);
        }
    }

    public void checkForWater() {
        this.waterblocks = 0;
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            if (this.world.getBlockState(this.getPos().offset(facing)).getBlock() != Blocks.WATER) continue;
            ++this.waterblocks;
        }
    }

    public double getMaxPower() {
        return 1000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getMaxOutput() {
        return 32.0;
    }

    public double getMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }
}

