/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.idsu;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.tiles.idsu.IDSUManager;

public class TileIDSU
extends TilePowerAcceptor
implements IWrenchable {
    public String ownerUdid;
    public int tier;
    public int output;
    public double maxStorage;
    private double euLastTick = 0.0;
    private double euChange;
    private int ticks;

    public TileIDSU(int tier1, int output1, int maxStorage1) {
        super(tier1);
        this.tier = tier1;
        this.output = output1;
        this.maxStorage = maxStorage1;
    }

    public TileIDSU() {
        this(5, 2048, 100000000);
    }

    public double getEnergy() {
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return 0.0;
        }
        return IDSUManager.INSTANCE.getSaveDataForWorld((World)this.world, (String)this.ownerUdid).storedPower;
    }

    public void setEnergy(double energy) {
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return;
        }
        IDSUManager.INSTANCE.getSaveDataForWorld((World)this.world, (String)this.ownerUdid).storedPower = energy;
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
    }

    public double getMaxPower() {
        return 1.0E9;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return this.getFacingEnum() != direction;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return this.getFacingEnum() == direction;
    }

    public double getMaxOutput() {
        return this.output;
    }

    public double getMaxInput() {
        return this.maxStorage;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }

    public float getChargeLevel() {
        float ret = (float)this.getEnergy() / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.ownerUdid = nbttagcompound.getString("ownerUdid");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return nbttagcompound;
        }
        nbttagcompound.setString("ownerUdid", this.ownerUdid);
        return nbttagcompound;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.ticks == ConfigTechReborn.AverageEuOutTickTime) {
            this.euChange = -1.0;
            this.ticks = 0;
        } else {
            ++this.ticks;
            this.euChange += this.getEnergy() - this.euLastTick;
            if (this.euLastTick == this.getEnergy()) {
                this.euChange = 0.0;
            }
        }
        this.euLastTick = this.getEnergy();
        boolean needsInvUpdate = false;
        if (needsInvUpdate) {
            this.markDirty();
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean wrenchCanSetFacing(EntityPlayer p0, EnumFacing p1) {
        return true;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer p0) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.INTERDIMENSIONAL_SU, 1);
        this.writeToNBT(tileEntity);
        dropStack.setTagCompound(new NBTTagCompound());
        dropStack.getTagCompound().setTag("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public double getEuChange() {
        if (this.euChange == -1.0) {
            return -1.0;
        }
        return this.euChange / (double)this.ticks;
    }

    public void handleGuiInputFromClient(int id) {
        if (id == 0) {
            this.output += 256;
        }
        if (id == 1) {
            this.output += 64;
        }
        if (id == 2) {
            this.output -= 64;
        }
        if (id == 3) {
            this.output -= 256;
        }
        if (this.output > 4096) {
            this.output = 4096;
        }
        if (this.output <= -1) {
            this.output = 0;
        }
    }
}

