/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.lesu;

import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.config.ConfigTechReborn;
import techreborn.tiles.lesu.LesuNetwork;
import techreborn.tiles.lesu.TileLesuStorage;

public class TileLesu
extends TilePowerAcceptor {
    public int connectedBlocks = 0;
    public Inventory inventory = new Inventory(2, "TileAesu", 64, (TileEntity)this);
    private ArrayList<LesuNetwork> countedNetworks = new ArrayList();
    private double euLastTick = 0.0;
    private double euChange;
    private int ticks;
    private int output;
    private int maxStorage;

    public TileLesu() {
        super(5);
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.world.isRemote) {
            return;
        }
        this.countedNetworks.clear();
        this.connectedBlocks = 0;
        for (EnumFacing dir : EnumFacing.values()) {
            LesuNetwork network;
            if (!(this.world.getTileEntity(new BlockPos(this.getPos().getX() + dir.getFrontOffsetX(), this.getPos().getY() + dir.getFrontOffsetY(), this.getPos().getZ() + dir.getFrontOffsetZ())) instanceof TileLesuStorage) || ((TileLesuStorage)this.world.getTileEntity((BlockPos)new BlockPos((int)(this.getPos().getX() + dir.getFrontOffsetX()), (int)(this.getPos().getY() + dir.getFrontOffsetY()), (int)(this.getPos().getZ() + dir.getFrontOffsetZ())))).network == null || this.countedNetworks.contains(network = ((TileLesuStorage)this.world.getTileEntity((BlockPos)new BlockPos((int)(this.getPos().getX() + dir.getFrontOffsetX()), (int)(this.getPos().getY() + dir.getFrontOffsetY()), (int)(this.getPos().getZ() + dir.getFrontOffsetZ())))).network) || network.master != null && network.master != this) continue;
            this.connectedBlocks += network.storages.size();
            this.countedNetworks.add(network);
            network.master = this;
            break;
        }
        this.maxStorage = (this.connectedBlocks + 1) * ConfigTechReborn.LesuStoragePerBlock;
        this.output = this.connectedBlocks * ConfigTechReborn.ExtraOutputPerLesuBlock + ConfigTechReborn.BaseLesuOutput;
        if (this.ticks == ConfigTechReborn.AverageEuOutTickTime) {
            this.euChange = -1.0;
            this.ticks = 0;
        } else {
            ++this.ticks;
            if (this.euChange == -1.0) {
                this.euChange = 0.0;
            }
            this.euChange += this.getEnergy() - this.euLastTick;
            if (this.euLastTick == this.getEnergy()) {
                this.euChange = 0.0;
            }
        }
        this.euLastTick = this.getEnergy();
    }

    public double getEuChange() {
        if (this.euChange == -1.0) {
            return 0.0;
        }
        return this.euChange / (double)this.ticks;
    }

    public double getMaxPower() {
        return this.maxStorage;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return direction != this.getFacingEnum();
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return direction == this.getFacingEnum();
    }

    public double getMaxOutput() {
        return this.output;
    }

    public double getMaxInput() {
        return 8192.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }
}

