/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.lesu;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.tiles.lesu.LesuNetwork;

public class TileLesuStorage
extends TileLegacyMachineBase {
    public LesuNetwork network;

    public void updateEntity() {
        super.updateEntity();
        if (this.network == null) {
            this.findAndJoinNetwork(this.world, this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
        } else if (this.network.master != null && this.network.master.getWorld().getTileEntity(new BlockPos(this.network.master.getPos().getX(), this.network.master.getPos().getY(), this.network.master.getPos().getZ())) != this.network.master) {
            this.network.master = null;
        }
    }

    public final void findAndJoinNetwork(World world, int x, int y, int z) {
        this.network = new LesuNetwork();
        this.network.addElement(this);
        for (EnumFacing direction : EnumFacing.values()) {
            if (!(world.getTileEntity(new BlockPos(x + direction.getFrontOffsetX(), y + direction.getFrontOffsetY(), z + direction.getFrontOffsetZ())) instanceof TileLesuStorage)) continue;
            TileLesuStorage lesu = (TileLesuStorage)world.getTileEntity(new BlockPos(x + direction.getFrontOffsetX(), y + direction.getFrontOffsetY(), z + direction.getFrontOffsetZ()));
            if (lesu.network == null) continue;
            lesu.network.merge(this.network);
        }
    }

    public final void setNetwork(LesuNetwork n) {
        if (n != null) {
            this.network = n;
            this.network.addElement(this);
        }
    }

    public final void resetNetwork() {
        this.network = null;
    }

    public final void removeFromNetwork() {
        if (this.network != null) {
            this.network.removeElement(this);
        }
    }

    public final void rebuildNetwork() {
        this.removeFromNetwork();
        this.resetNetwork();
        this.findAndJoinNetwork(this.world, this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
    }
}

