/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.misc.Location;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.blocks.BlockMachineCasing;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.multiblocks.MultiBlockCasing;
import techreborn.tiles.TileMachineCasing;

public class TileBlastFurnace
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ITileRecipeHandler<BlastFurnaceRecipe>,
IRecipeCrafterProvider,
IContainerProvider {
    public static int euTick = 5;
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileBlastFurnace", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int capacity = 1000;
    private int cachedHeat;

    public TileBlastFurnace() {
        super(ConfigTechReborn.CentrifugeTier);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.crafter = new RecipeCrafter(Reference.blastFurnaceRecipe, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public void updateEntity() {
        super.updateEntity();
        this.crafter.updateEntity();
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE, 1);
    }

    public int getHeat() {
        for (EnumFacing direction : EnumFacing.values()) {
            TileEntity tileEntity = this.world.getTileEntity(new BlockPos(this.getPos().getX() + direction.getFrontOffsetX(), this.getPos().getY() + direction.getFrontOffsetY(), this.getPos().getZ() + direction.getFrontOffsetZ()));
            if (!(tileEntity instanceof TileMachineCasing) || !((TileMachineCasing)tileEntity).isConnected() || !((TileMachineCasing)tileEntity).getMultiblockController().isAssembled()) continue;
            MultiBlockCasing casing = ((TileMachineCasing)tileEntity).getMultiblockController();
            Location location = new Location(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ(), direction);
            location.modifyPositionFromSide(direction, 1);
            int heat = 0;
            if (this.world.getBlockState(new BlockPos(location.getX(), location.getY() - 1, location.getZ())).getBlock() == tileEntity.getBlockType()) {
                return 0;
            }
            for (IMultiblockPart part : casing.connectedParts) {
                BlockMachineCasing casing1 = (BlockMachineCasing)this.world.getBlockState(part.getPos()).getBlock();
                heat += casing1.getHeatFromState(part.getWorld().getBlockState(part.getWorldLocation().toBlockPos()));
            }
            if (this.world.getBlockState(new BlockPos(location.getX(), location.getY(), location.getZ())).getBlock().getUnlocalizedName().equals("tile.lava") && this.world.getBlockState(new BlockPos(location.getX(), location.getY() + 1, location.getZ())).getBlock().getUnlocalizedName().equals("tile.lava")) {
                heat += 500;
            }
            return heat;
        }
        return 0;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.world.markBlockRangeForRenderUpdate(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
        this.readFromNBT(packet.getNbtCompound());
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.tickTime = tagCompound.getInteger("tickTime");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.writeUpdateToNBT(tagCompound);
        return tagCompound;
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.setInteger("tickTime", this.tickTime);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 3;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray = nArray3;
            nArray3[3] = 3;
        }
        return nArray;
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex >= 2) {
            return false;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2 || slotIndex == 3;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 128.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.HIGH;
    }

    @Override
    public boolean canCraft(TileEntity tile, BlastFurnaceRecipe recipe) {
        if (tile instanceof TileBlastFurnace) {
            TileBlastFurnace blastFurnace = (TileBlastFurnace)tile;
            return blastFurnace.getHeat() >= recipe.neededHeat;
        }
        return false;
    }

    @Override
    public boolean onCraft(TileEntity tile, BlastFurnaceRecipe recipe) {
        return true;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    public void setHeat(int heat) {
        this.cachedHeat = heat;
    }

    public int getCachedHeat() {
        return this.cachedHeat;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("blastfurnace").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 50, 27).slot(1, 50, 47).outputSlot(2, 92, 36).outputSlot(3, 110, 36).syncEnergyValue().syncCrafterValue().syncIntegerValue(this::getHeat, this::setHeat).addInventory().create();
    }
}

