/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.Reference;
import techreborn.api.recipe.ITileRecipeHandler;
import techreborn.api.recipe.machines.IndustrialGrinderRecipe;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.tiles.multiblock.MultiblockChecker;

public class TileIndustrialGrinder
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ITileRecipeHandler<IndustrialGrinderRecipe>,
IRecipeCrafterProvider,
IContainerProvider {
    public static final int TANK_CAPACITY = 16000;
    public Inventory inventory = new Inventory(7, "TileGrinder", 64, (TileEntity)this);
    public Tank tank = new Tank("TileGrinder", 16000, (TileEntity)this);
    public RecipeCrafter crafter;
    public MultiblockChecker multiblockChecker;

    public TileIndustrialGrinder() {
        super(ConfigTechReborn.CentrifugeTier);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.crafter = new RecipeCrafter(Reference.industrialGrinderRecipe, (TileEntity)this, 1, 4, this.inventory, inputs, outputs);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.INDUSTRIAL_GRINDER, 1);
    }

    public boolean getMutliBlock() {
        boolean down = this.multiblockChecker.checkRectY(1, 1, 0, MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, 0, new BlockPos(0, 2, 0));
        boolean blade = this.multiblockChecker.checkRingY(1, 1, 1, new BlockPos(0, 1, 0));
        IBlockState centerBlock = this.multiblockChecker.getBlock(0, 1, 0);
        boolean center = centerBlock.getBlock() == Blocks.WATER;
        return down && center && blade && up;
    }

    public void update() {
        super.update();
        if (this.multiblockChecker == null) {
            BlockPos pos = this.getPos().offset(this.getFacing().getOpposite(), 2).down();
            this.multiblockChecker = new MultiblockChecker(this.world, pos);
        }
        if (this.getMutliBlock()) {
            this.crafter.updateEntity();
        }
        FluidUtils.drainContainers((FluidTank)this.tank, (IInventory)this.inventory, (int)1, (int)6);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.tank.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[6];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray = nArray2;
            nArray2[5] = 5;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray3[2] = 2;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray = nArray3;
            nArray3[5] = 5;
        }
        return nArray;
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex >= 2) {
            return false;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2 || slotIndex == 3 || slotIndex == 4 || slotIndex == 5 || slotIndex == 6;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    @Override
    public boolean canCraft(TileEntity tile, IndustrialGrinderRecipe recipe) {
        FluidStack recipeFluid = recipe.fluidStack;
        FluidStack tankFluid = this.tank.getFluid();
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tankFluid == null) {
            return false;
        }
        return tankFluid.isFluidEqual(recipeFluid) && tankFluid.amount >= recipeFluid.amount;
    }

    @Override
    public boolean onCraft(TileEntity tile, IndustrialGrinderRecipe recipe) {
        FluidStack recipeFluid = recipe.fluidStack;
        FluidStack tankFluid = this.tank.getFluid();
        if (recipe.fluidStack == null) {
            return true;
        }
        if (tankFluid == null) {
            return false;
        }
        if (tankFluid.isFluidEqual(recipeFluid) && tankFluid.amount >= recipeFluid.amount) {
            if (tankFluid.amount == recipeFluid.amount) {
                this.tank.setFluid(null);
            } else {
                tankFluid.amount -= recipeFluid.amount;
            }
            return true;
        }
        return false;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("industrialgrinder").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(1, 34, 35).slot(0, 84, 43).outputSlot(2, 126, 18).outputSlot(3, 126, 36).outputSlot(4, 126, 54).outputSlot(5, 126, 72).outputSlot(6, 34, 55).syncEnergyValue().syncCrafterValue().addInventory().create();
    }
}

