/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.items.ItemDusts;
import techreborn.tiles.multiblock.MultiblockChecker;

public class TileIndustrialSawmill
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public Inventory inventory = new Inventory(5, "Sawmill", 64, (TileEntity)this);
    public Tank tank = new Tank("Sawmill", 16000, (TileEntity)this);
    public int tickTime;
    public MultiblockChecker multiblockChecker;

    public TileIndustrialSawmill() {
        super(2);
    }

    public void update() {
        super.update();
        if (this.getMutliBlock()) {
            ItemStack wood = this.inventory.getStackInSlot(0);
            if (this.tickTime == 0) {
                if (wood != null) {
                    for (int id : OreDictionary.getOreIDs((ItemStack)wood)) {
                        String name = OreDictionary.getOreName((int)id);
                        if (!name.equals("logWood") || !this.canAddOutput(2, 10) || !this.canAddOutput(3, 5) || !this.canAddOutput(4, 3) || !this.canUseEnergy(128.0) || this.tank.isEmpty() || this.tank.getFluid().amount < 1000) continue;
                        --wood.stackSize;
                        if (wood.stackSize == 0) {
                            this.setInventorySlotContents(0, null);
                        }
                        this.tank.drain(1000, true);
                        this.useEnergy(128.0);
                        this.syncWithAll();
                        this.tickTime = 1;
                    }
                }
            } else if (++this.tickTime > 100) {
                Random rnd = this.world.rand;
                this.addOutput(2, new ItemStack(Blocks.PLANKS, 6 + rnd.nextInt(4)));
                if (rnd.nextInt(4) != 0) {
                    ItemStack pulp = ItemDusts.getDustByName("sawDust", 2 + rnd.nextInt(3));
                    this.addOutput(3, pulp);
                }
                if (rnd.nextInt(3) == 0) {
                    ItemStack paper = new ItemStack(Items.PAPER, 1 + rnd.nextInt(2));
                    this.addOutput(4, paper);
                }
                this.tickTime = 0;
            }
        }
        FluidUtils.drainContainers((FluidTank)this.tank, (IInventory)this.inventory, (int)1, (int)4);
    }

    public void addOutput(int slot, ItemStack stack) {
        if (this.getStackInSlot(slot) == null) {
            this.setInventorySlotContents(slot, stack);
        }
        this.getStackInSlot((int)slot).stackSize += stack.stackSize;
    }

    public boolean canAddOutput(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        return stack == null || this.getInventoryStackLimit() - stack.stackSize >= amount;
    }

    public void validate() {
        super.validate();
        this.multiblockChecker = new MultiblockChecker(this.world, this.getPos().down(3));
    }

    public boolean getMutliBlock() {
        boolean down = this.multiblockChecker.checkRectY(1, 1, 0, MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, 0, new BlockPos(0, 2, 0));
        boolean blade = this.multiblockChecker.checkRingY(1, 1, 1, new BlockPos(0, 1, 0));
        IBlockState centerBlock = this.multiblockChecker.getBlock(0, 1, 0);
        boolean center = centerBlock.getBlock() == Blocks.WATER;
        return down && center && blade && up;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.INDUSTRIAL_SAWMILL, 1);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.tank.readFromNBT(tagCompound);
        this.tickTime = tagCompound.getInteger("tickTime");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.tank.writeToNBT(tagCompound);
        tagCompound.setInteger("tickTime", this.tickTime);
        return tagCompound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{0, 2, 3, 4, 5};
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return index >= 2;
    }

    public int getProgressScaled(int scale) {
        if (this.tickTime != 0) {
            return this.tickTime * scale / 100;
        }
        return 0;
    }

    public double getMaxPower() {
        return 64000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("industrialsawmill").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).slot(0, 32, 26).slot(1, 32, 44).outputSlot(2, 84, 35).outputSlot(3, 102, 35).outputSlot(4, 120, 35).syncEnergyValue().addInventory().create();
    }
}

