/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.storage;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.blocks.storage.BlockEnergyStorage;

public class TileEnergyStorage
extends TilePowerAcceptor
implements IWrenchable,
ITickable,
IInventoryProvider {
    public Inventory inventory;
    public String name;
    public Block wrenchDrop;
    public EnumPowerTier tier;
    public int maxInput;
    public int maxOutput;
    public int maxStorage;

    public TileEnergyStorage(String name, int invSize, Block wrenchDrop, EnumPowerTier tier, int maxInput, int maxOuput, int maxStorage) {
        super(1);
        this.inventory = new Inventory(invSize, "Tile" + name, 64, (TileEntity)this);
        this.wrenchDrop = wrenchDrop;
        this.tier = tier;
        this.name = name;
        this.maxInput = maxInput;
        this.maxOutput = maxOuput;
        this.maxStorage = maxStorage;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return true;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public void updateEntity() {
        IEnergyItemInfo item;
        ItemStack stack;
        if (this.inventory.getStackInSlot(0) != null) {
            stack = this.inventory.getStackInSlot(0);
            if (!(stack.getItem() instanceof IEnergyItemInfo)) {
                return;
            }
            item = (IEnergyItemInfo)this.inventory.getStackInSlot(0).getItem();
            if (PoweredItem.getEnergy((ItemStack)stack) != PoweredItem.getMaxPower((ItemStack)stack) && this.canUseEnergy(item.getMaxTransfer(stack))) {
                this.useEnergy(item.getMaxTransfer(stack));
                PoweredItem.setEnergy((double)(PoweredItem.getEnergy((ItemStack)stack) + item.getMaxTransfer(stack)), (ItemStack)stack);
            }
        }
        if (this.inventory.getStackInSlot(1) != null) {
            stack = this.inventory.getStackInSlot(1);
            if (!(stack.getItem() instanceof IEnergyItemInfo)) {
                return;
            }
            item = (IEnergyItemInfo)stack.getItem();
            if (item.canProvideEnergy(stack) && this.getEnergy() != this.getMaxPower() && PoweredItem.getEnergy((ItemStack)stack) > 0.0) {
                this.addEnergy(item.getMaxTransfer(stack));
                PoweredItem.setEnergy((double)(PoweredItem.getEnergy((ItemStack)stack) - item.getMaxTransfer(stack)), (ItemStack)stack);
            }
        }
    }

    public void setFacing(EnumFacing enumFacing) {
        this.world.setBlockState(this.pos, this.world.getBlockState(this.pos).withProperty((IProperty)BlockEnergyStorage.FACING, (Comparable)enumFacing));
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.wrenchDrop);
    }

    public double getMaxPower() {
        return this.maxStorage;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return this.getFacingEnum() != direction;
    }

    public EnumFacing getFacingEnum() {
        Block block = this.world.getBlockState(this.pos).getBlock();
        if (block instanceof BlockEnergyStorage) {
            return ((BlockEnergyStorage)block).getFacing(this.world.getBlockState(this.pos));
        }
        return null;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return this.getFacing() == direction;
    }

    public double getMaxOutput() {
        return this.maxOutput;
    }

    public double getMaxInput() {
        return this.maxInput;
    }

    public EnumPowerTier getTier() {
        return this.tier;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }
}

