/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.teir1;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.utils.upgrade.UpgradeHandler;

public class TileCompressor
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IRecipeCrafterProvider,
IContainerProvider {
    public Inventory inventory = new Inventory(6, "TileCompressor", 64, (TileEntity)this);
    public UpgradeHandler upgradeHandler;
    public RecipeCrafter crafter;
    public int capacity = 1000;

    public TileCompressor() {
        super(1);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.crafter = new RecipeCrafter(Reference.compressorRecipe, (TileEntity)this, 2, 1, this.inventory, inputs, outputs);
        this.upgradeHandler = new UpgradeHandler(this.crafter, this.inventory, 2, 3, 4, 5);
    }

    public void update() {
        if (!this.world.isRemote) {
            super.update();
            this.crafter.updateEntity();
            this.upgradeHandler.tick();
            this.charge(3);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.COMPRESSOR, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        if (side.equals((Object)EnumFacing.UP)) {
            return new int[]{0};
        }
        if (side.equals((Object)EnumFacing.DOWN)) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean canInsertItem(int Index, ItemStack itemStack, EnumFacing side) {
        return Index == 0;
    }

    public boolean canExtractItem(int Index, ItemStack itemStack, EnumFacing side) {
        return Index == 1;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("compressor").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).syncEnergyValue().syncCrafterValue().addInventory().create();
    }
}

