/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.teir1;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileElectricFurnace
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public Inventory inventory = new Inventory(6, "TileElectricFurnace", 64, (TileEntity)this);
    public int capacity = 1000;
    public int progress;
    public int fuelScale = 100;
    public int cost = 8;
    int input1 = 0;
    int output = 1;

    public TileElectricFurnace() {
        super(1);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public void update() {
        if (!this.world.isRemote) {
            super.update();
            boolean burning = this.isBurning();
            boolean updateInventory = false;
            if (this.isBurning() && this.canSmelt()) {
                this.updateState();
                ++this.progress;
                if (this.progress % 10 == 0) {
                    this.useEnergy(this.cost);
                }
                if (this.progress >= this.fuelScale) {
                    this.progress = 0;
                    this.cookItems();
                    updateInventory = true;
                }
            } else {
                this.progress = 0;
                this.updateState();
            }
            if (burning != this.isBurning()) {
                updateInventory = true;
            }
            if (updateInventory) {
                this.markDirty();
            }
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
            if (this.getStackInSlot(this.output) == null) {
                this.setInventorySlotContents(this.output, itemstack.copy());
            } else if (this.getStackInSlot(this.output).isItemEqual(itemstack)) {
                this.getStackInSlot((int)this.output).stackSize += itemstack.stackSize;
            }
            if (this.getStackInSlot((int)this.input1).stackSize > 1) {
                this.decrStackSize(this.input1, 1);
            } else {
                this.setInventorySlotContents(this.input1, null);
            }
        }
    }

    public boolean canSmelt() {
        if (this.getStackInSlot(this.input1) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
        if (itemstack == null) {
            return false;
        }
        if (this.getStackInSlot(this.output) == null) {
            return true;
        }
        if (!this.getStackInSlot(this.output).isItemEqual(itemstack)) {
            return false;
        }
        int result = this.getStackInSlot((int)this.output).stackSize + itemstack.stackSize;
        return result <= this.getInventoryStackLimit() && result <= itemstack.getMaxStackSize();
    }

    public boolean isBurning() {
        return this.getEnergy() > (double)this.cost;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.instance().getSmeltingResult(stack);
        if (result != null) {
            return result.copy();
        }
        return null;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
        if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
            if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.progress > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.progress > 0), this.world, this.pos);
            }
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ELECTRIC_FURNACE, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        if (side.equals((Object)EnumFacing.UP)) {
            return new int[]{0};
        }
        if (side.equals((Object)EnumFacing.DOWN)) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 2) {
            return false;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 1;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.progress;
    }

    public void setBurnTime(int burnTime) {
        this.progress = burnTime;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("electricfurnace").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).addInventory().create();
    }
}

