/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.teir1;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.items.ItemParts;

public class TileRecycler
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    private final Inventory inventory = new Inventory(6, "TileRecycler", 64, (TileEntity)this);
    private final int capacity = 1000;
    private final int cost = 2;
    private final int time = 15;
    private final int chance = 6;
    private boolean isBurning;
    private int progress;

    public TileRecycler() {
        super(1);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.time;
    }

    public void updateEntity() {
        if (this.world.isRemote) {
            return;
        }
        boolean updateInventory = false;
        if (this.canRecycle() && !this.isBurning() && this.getEnergy() != 0.0) {
            this.setBurning(true);
        } else if (this.isBurning()) {
            if (this.useEnergy(this.cost) != (double)this.cost) {
                this.setBurning(false);
            }
            ++this.progress;
            if (this.progress >= this.time) {
                this.progress = 0;
                this.recycleItems();
                updateInventory = true;
                this.setBurning(false);
            }
        }
        this.updateState();
        if (updateInventory) {
            this.markDirty();
        }
    }

    public void recycleItems() {
        ItemStack itemstack = ItemParts.getPartByName("scrap");
        int randomchance = this.world.rand.nextInt(this.chance);
        if (randomchance == 1) {
            if (this.getStackInSlot(1) == null) {
                this.setInventorySlotContents(1, itemstack.copy());
            } else {
                this.getStackInSlot((int)1).stackSize += itemstack.stackSize;
            }
        }
        this.decrStackSize(0, 1);
    }

    public boolean canRecycle() {
        return this.getStackInSlot(0) != null && this.hasSlotGotSpace(1);
    }

    public boolean hasSlotGotSpace(int slot) {
        if (this.getStackInSlot(slot) == null) {
            return true;
        }
        if (this.getStackInSlot((int)slot).stackSize < this.getStackInSlot(slot).getMaxStackSize()) {
            return true;
        }
        return true;
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean burning) {
        this.isBurning = burning;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
        if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
            if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.isBurning) {
                blockMachineBase.setActive(Boolean.valueOf(this.isBurning), this.world, this.pos);
            }
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.RECYCLER, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        if (side.equals((Object)EnumFacing.UP)) {
            return new int[]{0};
        }
        if (side.equals((Object)EnumFacing.DOWN)) {
            return new int[]{1};
        }
        return new int[0];
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 1) {
            return false;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 1;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("recycler").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).slot(1, 101, 45).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).addInventory().create();
    }
}

