/*
 * Decompiled with CFR 0.152.
 */
package techreborn.utils.upgrade;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import techreborn.utils.upgrade.IMachineUpgrade;

public class UpgradeHandler {
    RecipeCrafter crafter;
    Inventory inventory;
    ArrayList<Integer> slots = new ArrayList();

    public UpgradeHandler(RecipeCrafter crafter, Inventory inventory, int ... slots) {
        this.crafter = crafter;
        this.inventory = inventory;
        for (int slot : slots) {
            this.slots.add(slot);
        }
    }

    public void tick() {
        if (this.crafter.parentTile.getWorld().isRemote) {
            return;
        }
        this.crafter.resetPowerMulti();
        this.crafter.resetSpeedMulti();
        for (int slot : this.slots) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == null || !(stack.getItem() instanceof IMachineUpgrade)) continue;
            ((IMachineUpgrade)stack.getItem()).processUpgrade(this.crafter, stack);
        }
        if (this.crafter.currentRecipe != null) {
            this.crafter.currentNeededTicks = (int)((double)this.crafter.currentRecipe.tickTime() * (1.0 - this.crafter.getSpeedMultiplier()));
        }
    }
}

