/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import techreborn.Core;
import techreborn.blocks.BlockRubberLeaves;
import techreborn.blocks.BlockRubberLog;
import techreborn.init.ModBlocks;

public class RubberTreeGenerator
extends WorldGenerator {
    boolean isWorldGen = true;

    public RubberTreeGenerator() {
    }

    public RubberTreeGenerator(boolean isWorldGen) {
        super(!isWorldGen);
        this.isWorldGen = isWorldGen;
    }

    public boolean generate(World worldIn, Random rand, BlockPos position) {
        int x = position.getX();
        int z = position.getZ();
        int retries = rand.nextInt(3) + 2;
        if (this.isWorldGen) {
            for (int c = 0; c < retries; ++c) {
                int y;
                for (y = worldIn.getActualHeight() - 1; worldIn.isAirBlock(new BlockPos(x, y, z)) && y > 0; --y) {
                }
                if (!this.growTree(worldIn, rand, x, y + 1, z)) {
                    --retries;
                }
                x += rand.nextInt(16) - 8;
                z += rand.nextInt(16) - 8;
            }
        } else {
            int y;
            for (y = worldIn.getActualHeight() - 1; worldIn.isAirBlock(new BlockPos(x, y, z)) && y > 0; --y) {
            }
            return this.growTree(worldIn, rand, x, y + 1, z);
        }
        return false;
    }

    public boolean growTree(World world, Random rand, int x, int y, int z) {
        int treeHeight = rand.nextInt(5) + Core.worldGen.config.rubberTreeConfig.treeBaseHeight;
        int worldHeight = world.getHeight();
        if (y >= 1 && y + treeHeight + 1 <= worldHeight) {
            IBlockState baseSate = world.getBlockState(new BlockPos(x, y - 1, z));
            Block baseBlock = baseSate.getBlock();
            boolean hasPlacedBlock = false;
            if (baseBlock != null && baseBlock.canSustainPlant(baseSate, (IBlockAccess)world, new BlockPos(x, y - 1, z), EnumFacing.UP, (IPlantable)ModBlocks.RUBBER_SAPLING) && y < worldHeight - treeHeight - 1) {
                int zOffset;
                int xOffset;
                int yOffset;
                for (yOffset = y; yOffset <= y + 1 + treeHeight; ++yOffset) {
                    int radius = 1;
                    if (yOffset == y) {
                        radius = 0;
                    }
                    if (yOffset >= y + 1 + treeHeight - 2) {
                        radius = 2;
                    }
                    if (yOffset >= 0 & yOffset < worldHeight) {
                        for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                            for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                                IBlockState state = world.getBlockState(new BlockPos(xOffset, yOffset, zOffset));
                                Block block = state.getBlock();
                                if (block == null || block.isLeaves(state, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) || block.isAir(state, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset))) continue;
                                return false;
                            }
                        }
                        continue;
                    }
                    return false;
                }
                BlockPos treeBase = new BlockPos(x, y, z);
                BlockPos treeRoot = treeBase.down();
                IBlockState state = world.getBlockState(treeRoot);
                state.getBlock().onPlantGrow(state, world, treeRoot, treeBase);
                for (yOffset = y - 3 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                    int var12 = yOffset - (y + treeHeight);
                    int center = 1 - var12 / 2;
                    for (xOffset = x - center; xOffset <= x + center; ++xOffset) {
                        int xPos = xOffset - x;
                        int t = xPos >> 15;
                        xPos = xPos + t ^ t;
                        for (zOffset = z - center; zOffset <= z + center; ++zOffset) {
                            int zPos = zOffset - z;
                            t = zPos >> 31;
                            zPos = zPos + t ^ t;
                            IBlockState state1 = world.getBlockState(new BlockPos(xOffset, yOffset, zOffset));
                            Block block = state1.getBlock();
                            if (!(xPos != center | zPos != center) && (rand.nextInt(2) == 0 || var12 == 0) || block != null && !block.isLeaves(state1, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) && !block.isAir(state1, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) && !block.canBeReplacedByLeaves(state1, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset))) continue;
                            this.setBlockAndNotifyAdequately(world, new BlockPos(xOffset, yOffset, zOffset), ModBlocks.RUBBER_LEAVES.getDefaultState());
                            hasPlacedBlock = true;
                        }
                    }
                }
                BlockPos topLogPos = null;
                for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                    BlockPos blockpos = new BlockPos(x, y + yOffset, z);
                    IBlockState state1 = world.getBlockState(blockpos);
                    Block block = state1.getBlock();
                    if (block != null && !block.isAir(state1, (IBlockAccess)world, blockpos) && !block.isLeaves(state1, (IBlockAccess)world, blockpos) && !block.isReplaceable((IBlockAccess)world, blockpos)) continue;
                    IBlockState newState = ModBlocks.RUBBER_LOG.getDefaultState();
                    boolean isAddingSap = false;
                    if (rand.nextInt(Core.worldGen.config.rubberTreeConfig.sapRarity) == 0) {
                        newState = newState.withProperty((IProperty)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)BlockRubberLog.SAP_SIDE, (Comparable)EnumFacing.getHorizontal((int)rand.nextInt(4)));
                        isAddingSap = true;
                    }
                    if (isAddingSap) {
                        world.setBlockState(blockpos, newState, 2);
                    } else {
                        this.setBlockAndNotifyAdequately(world, blockpos, newState);
                    }
                    hasPlacedBlock = true;
                    topLogPos = blockpos;
                }
                if (topLogPos != null) {
                    for (int i = 0; i < Core.worldGen.config.rubberTreeConfig.spireHeight; ++i) {
                        BlockPos spikePos = topLogPos.up(i);
                        this.setBlockAndNotifyAdequately(world, spikePos, ModBlocks.RUBBER_LEAVES.getDefaultState().withProperty((IProperty)BlockRubberLeaves.DECAYABLE, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
            return hasPlacedBlock;
        }
        return false;
    }
}

