package techreborn.blocks;

import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IAdvancedRotationTexture;

import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TileDigitalChest;
import techreborn.tiles.TileTechStorageBase;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockDigitalChest extends BlockMachineBase implements IAdvancedRotationTexture {

	private final String prefix = "techreborn:blocks/machine/greg_machines/";

	public BlockDigitalChest() {
		super();
		this.func_149663_c("techreborn.digitalChest");
		this.func_149647_a(TechRebornCreativeTab.instance);
	}

	@Override
	protected void dropInventory(final World world, final BlockPos pos) {
		final TileEntity tileEntity = world.func_175625_s(pos);

		if (tileEntity == null) {
			return;
		}
		if (!(tileEntity instanceof TileTechStorageBase)) {
			return;
		}

		final TileTechStorageBase inventory = (TileTechStorageBase) tileEntity;

		final List<ItemStack> items = new ArrayList<>();

		final List<ItemStack> droppables = inventory.getContentDrops();
		for (int i = 0; i < droppables.size(); i++) {
			final ItemStack itemStack = droppables.get(i);

			if (itemStack == null) {
				continue;
			}
			if (itemStack != null && itemStack.field_77994_a > 0) {
				if (itemStack.func_77973_b() instanceof ItemBlock) {
					if (((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase
							|| ((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid
							|| ((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid) {
						continue;
					}
				}
			}
			items.add(itemStack.func_77946_l());
		}

		for (final ItemStack itemStack : items) {
			final Random rand = new Random();

			final float dX = rand.nextFloat() * 0.8F + 0.1F;
			final float dY = rand.nextFloat() * 0.8F + 0.1F;
			final float dZ = rand.nextFloat() * 0.8F + 0.1F;

			final EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + dX, pos.func_177956_o() + dY, pos.func_177952_p() + dZ,
					itemStack.func_77946_l());

			if (itemStack.func_77942_o()) {
				entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
			}

			final float factor = 0.05F;
			entityItem.field_70159_w = rand.nextGaussian() * factor;
			entityItem.field_70181_x = rand.nextGaussian() * factor + 0.2F;
			entityItem.field_70179_y = rand.nextGaussian() * factor;
			world.func_72838_d(entityItem);
			itemStack.field_77994_a = (0);
		}
	}

	@Override
	public TileEntity func_149915_a(final World p_149915_1_, final int p_149915_2_) {
		return new TileDigitalChest();
	}

	@Override
	public boolean onBlockActivated(final World world, final int x, final int y, final int z, final EntityPlayer player, final int side, final float hitX,
			final float hitY, final float hitZ) {
		if (!player.func_70093_af())
			player.openGui(Core.INSTANCE, EGui.DIGITAL_CHEST.ordinal(), world, x, y, z);
		return true;
	}

	@Override
	public String getFront(final boolean isActive) {
		return this.prefix + "quantum_chest";
	}

	@Override
	public String getSide(final boolean isActive) {
		return this.prefix + "qchest_side";
	}

	@Override
	public String getTop(final boolean isActive) {
		return this.prefix + "quantum_top";
	}

	@Override
	public String getBottom(final boolean isActive) {
		return this.prefix + "machine_bottom";
	}
}
