package techreborn.blocks;

import com.google.common.base.CaseFormat;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.BaseBlock;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModBlocks;

import java.security.InvalidParameterException;

public class BlockMachineFrame extends BaseBlock {
	public static final String[] types = new String[] { "machine", "advancedMachine", "highlyAdvancedMachine" };
	public static final PropertyInteger METADATA = PropertyInteger.func_177719_a("type", 0, types.length - 1);

	public BlockMachineFrame(Material material) {
		super(material);
		func_149663_c("techreborn.machineFrame");
		func_149647_a(TechRebornCreativeTab.instance);
		func_149711_c(1f);
		this.func_180632_j(this.func_176223_P().func_177226_a(METADATA, 0));
	}

	public static ItemStack getFrameByName(String name, int count) {
		name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
		for (int i = 0; i < types.length; i++) {
			if (types[i].equalsIgnoreCase(name)) {
				return new ItemStack(ModBlocks.MACHINE_FRAMES, count, i);
			}
		}
		throw new InvalidParameterException("The part " + name + " could not be found.");
	}

	public static ItemStack getFrameByName(String name) {
		return getFrameByName(name, 1);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
		for (int meta = 0; meta < types.length; meta++) {
			list.add(new ItemStack(item, 1, meta));
		}
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(METADATA);
	}

	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, METADATA);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(METADATA, meta);
	}

}
