package techreborn.blocks;

import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import reborncore.RebornCore;
import reborncore.common.BaseBlock;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.entitys.EntityNukePrimed;

/**
 * Created by Mark on 13/03/2016.
 */
public class BlockNuke extends BaseBlock implements ITexturedBlock {
	public static final PropertyBool OVERLAY = PropertyBool.func_177716_a("overlay");

	public BlockNuke() {
		super(Material.field_151590_u);
		func_149663_c("techreborn.nuke");
		func_149647_a(TechRebornCreativeTabMisc.instance);
		RebornCore.jsonDestroyer.registerObject(this);
		this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(OVERLAY, false));
	}

	public void explode(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
		if (!worldIn.field_72995_K) {
			EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (double) ((float) pos.func_177958_n() + 0.5F),
				(double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.5F), igniter);
			worldIn.func_72838_d(entitynukeprimed);
			// worldIn.playSoundAtEntity(entitynukeprimed, "game.tnt.primed",
			// 1.0F, 1.0F);
		}
	}

	@Override
	public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
		if (!worldIn.field_72995_K) {
			EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (double) ((float) pos.func_177958_n() + 0.5F),
				(double) pos.func_177956_o(), (double) ((float) pos.func_177952_p() + 0.5F), explosionIn.func_94613_c());
			entitynukeprimed.fuse = worldIn.field_73012_v.nextInt(entitynukeprimed.fuse / 4) + entitynukeprimed.fuse / 8;
			worldIn.func_72838_d(entitynukeprimed);
		}
	}

	public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
		if (!worldIn.field_72995_K && entityIn instanceof EntityArrow) {
			EntityArrow entityarrow = (EntityArrow) entityIn;

			if (entityarrow.func_70027_ad()) {
				this.explode(worldIn, pos, state, entityarrow.field_70250_c instanceof EntityLivingBase
				                                  ? (EntityLivingBase) entityarrow.field_70250_c : null);
				worldIn.func_175698_g(pos);
			}
		}
	}

	public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
		super.func_176213_c(worldIn, pos, state);
		if (worldIn.func_175640_z(pos)) {
			this.explode(worldIn, pos, state, null);
			worldIn.func_175698_g(pos);
		}
	}

	/**
	 * Called when a neighboring block changes.
	 */
	public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
		if (worldIn.func_175640_z(pos)) {
			this.explode(worldIn, pos, state, null);
			worldIn.func_175698_g(pos);
		}
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn,
	                                EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
		return false;
	}

	@Override
	public String getTextureNameFromState(IBlockState iBlockState, EnumFacing enumFacing) {
		if (iBlockState.func_177229_b(OVERLAY)) {
			return "techreborn:blocks/nuke_front";
		}
		if (enumFacing == EnumFacing.UP || enumFacing == EnumFacing.DOWN) {
			return "techreborn:blocks/nuke_top";
		}
		return "techreborn:blocks/nuke_side";
	}

	@Override
	public int amountOfStates() {
		return 2;
	}

	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(OVERLAY) ? 1 : 0;
	}

	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(OVERLAY, (meta & 1) > 0);
	}

	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, OVERLAY);
	}

}
