package techreborn.blocks;

import com.google.common.collect.Lists;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.StringUtils;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModBlocks;
import techreborn.world.config.IOreNameProvider;

import java.security.InvalidParameterException;
import java.util.List;

public class BlockOre2 extends Block implements IOreNameProvider {

	public static final String[] ores = new String[] { "copper", "tin" };
	static List<String> oreNamesList = Lists.newArrayList(ArrayUtils.arrayToLowercase(ores));
	public PropertyString VARIANTS = new PropertyString("type", oreNamesList);

	public BlockOre2(Material material) {
		super(material);
		func_149663_c("techreborn.ore2");
		func_149647_a(TechRebornCreativeTabMisc.instance);
		func_149711_c(2.0f);
		setHarvestLevel("pickaxe", 1);
		this.func_180632_j(this.func_176203_a(0));
	}

	public static ItemStack getOreByName(String name, int count) {
		for (int i = 0; i < ores.length; i++) {
			if (ores[i].equalsIgnoreCase(name)) {
				return new ItemStack(ModBlocks.ORE2, count, i);
			}
		}
		throw new InvalidParameterException("The ore block " + name + " could not be found.");
	}

	public static ItemStack getOreByName(String name) {
		return getOreByName(name, 1);
	}

	public IBlockState getBlockStateFromName(String name) {
		int index = -1;
		for (int i = 0; i < ores.length; i++) {
			if (ores[i].equalsIgnoreCase(name)) {
				index = i;
				break;
			}
		}
		if (index == -1) {
			throw new InvalidParameterException("The ore block " + name + " could not be found.");
		}
		return func_176203_a(index);
	}

	@Override
	protected boolean func_149700_E() {
		return true;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
		for (int meta = 0; meta < ores.length; meta++) {
			list.add(new ItemStack(item, 1, meta));
		}
	}

	@Override
	public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos,
	                              EntityPlayer player) {
		return new ItemStack(this, 1, func_176201_c(state));
	}

	//	@Override
	//	public int damageDropped(IBlockState state)
	//	{
	//		int meta = getMetaFromState(state);
	//		if (meta == 2)
	//		{
	//			return 0;
	//		} else if (meta == 3)
	//		{
	//			return 1;
	//		} else if (meta == 5)
	//		{
	//			return 60;
	//		}
	//		return meta;
	//	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		if (meta > ores.length) {
			meta = 0;
		}
		return func_176194_O().func_177621_b().func_177226_a(VARIANTS, oreNamesList.get(meta));
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return oreNamesList.indexOf(state.func_177229_b(VARIANTS));
	}

	protected BlockStateContainer func_180661_e() {
		VARIANTS = new PropertyString("type", oreNamesList);
		return new BlockStateContainer(this, VARIANTS);
	}

	@Override
	public String getUserLoclisedName(IBlockState state) {
		return StringUtils.toFirstCapital(oreNamesList.get(func_176201_c(state)));
	}
}
