package techreborn.blocks;

import com.google.common.collect.Lists;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.StringUtils;
import techreborn.client.TechRebornCreativeTab;
import techreborn.lib.MessageIDs;
import techreborn.tiles.TilePlayerDectector;

import java.util.List;
import java.util.Random;

public class BlockPlayerDetector extends BlockMachineBase implements ITexturedBlock {

	public static final String[] types = new String[] { "all", "others", "you" };
	public PropertyString TYPE;
	static List<String> typeNamesList = Lists.newArrayList(ArrayUtils.arrayToLowercase(types));

	public BlockPlayerDetector() {
		super(true);
		func_149663_c("techreborn.playerDetector");
		func_149647_a(TechRebornCreativeTab.instance);
		func_149711_c(2f);
		this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, "all"));
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return Item.func_150898_a(this);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
		for (int meta = 0; meta < types.length; meta++) {
			list.add(new ItemStack(item, 1, meta));
		}
	}

	@Override
	public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
		return new TilePlayerDectector();
	}

	@Override
	public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
		return true;
	}

	@Override
	public boolean func_149744_f(IBlockState state) {
		return true;
	}

	@Override
	public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
		TileEntity entity = blockAccess.func_175625_s(pos);
		if (entity instanceof TilePlayerDectector) {
			return ((TilePlayerDectector) entity).isProvidingPower() ? 15 : 0;
		}
		return 0;
	}

	@Override
	public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
		TileEntity entity = blockAccess.func_175625_s(pos);
		if (entity instanceof TilePlayerDectector) {
			return ((TilePlayerDectector) entity).isProvidingPower() ? 15 : 0;
		}
		return 0;
	}

	@Override
	public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer,
	                            ItemStack stack) {
		super.func_180633_a(worldIn, pos, state, placer, stack);
		TileEntity tile = worldIn.func_175625_s(pos);
		if (tile instanceof TilePlayerDectector) {
			((TilePlayerDectector) tile).owenerUdid = placer.func_110124_au().toString();
		}
	}

	@Override
	public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer,
	                                EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
		String type = state.func_177229_b(TYPE);
		String newType = type;
		TextFormatting color = TextFormatting.GREEN;
		if (type.equals("all")) {
			newType = "others";
			color = TextFormatting.RED;
		} else if (type.equals("others")) {
			newType = "you";
			color = TextFormatting.BLUE;
		} else if (type.equals("you")) {
			newType = "all";
		}
		world.func_175656_a(pos, state.func_177226_a(TYPE, newType));
		if (!world.field_72995_K) {
			ChatUtils.sendNoSpamMessages(MessageIDs.playerDetectorID, new TextComponentString(
				TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.detects") + " " + color
					+ StringUtils.toFirstCapital(newType)));
		}
		return true;
	}

	@Override
	public String getTextureNameFromState(IBlockState blockState, EnumFacing facing) {
		return "techreborn:blocks/machines/tier1_machines/player_detector_" + types[func_176201_c(blockState)].toLowerCase();
	}

	@Override
	public int amountOfStates() {
		return types.length;
	}

	protected BlockStateContainer func_180661_e() {
		TYPE = new PropertyString("type", types);
		return new BlockStateContainer(this, TYPE);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		if (meta > types.length) {
			meta = 0;
		}
		return func_176194_O().func_177621_b().func_177226_a(TYPE, typeNamesList.get(meta));
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return typeNamesList.indexOf(state.func_177229_b(TYPE));
	}
}
