package techreborn.blocks;

import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IAdvancedRotationTexture;

import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TileQuantumChest;
import techreborn.tiles.TileTechStorageBase;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BlockQuantumChest extends BlockMachineBase implements IAdvancedRotationTexture {

	private final String prefix = "techreborn:blocks/machine/greg_machines/";

	public BlockQuantumChest() {
		super();
		this.func_149663_c("techreborn.quantumChest");
		this.func_149647_a(TechRebornCreativeTab.instance);
		this.func_149711_c(2.0F);
	}

	@Override
	protected void dropInventory(final World world, final BlockPos pos) {
		final TileEntity tileEntity = world.func_175625_s(pos);

		if (tileEntity == null) {
			return;
		}
		if (!(tileEntity instanceof TileTechStorageBase)) {
			return;
		}

		final TileTechStorageBase inventory = (TileTechStorageBase) tileEntity;

		final List<ItemStack> items = new ArrayList<>();

		final List<ItemStack> droppables = inventory.getContentDrops();
		for (int i = 0; i < droppables.size(); i++) {
			final ItemStack itemStack = droppables.get(i);

			if (itemStack == null) {
				continue;
			}
			if (itemStack != null && itemStack.field_77994_a > 0) {
				if (itemStack.func_77973_b() instanceof ItemBlock) {
					if (((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase
							|| ((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid
							|| ((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid) {
						continue;
					}
				}
			}
			items.add(itemStack.func_77946_l());
		}

		for (final ItemStack itemStack : items) {
			final Random rand = new Random();

			final float dX = rand.nextFloat() * 0.8F + 0.1F;
			final float dY = rand.nextFloat() * 0.8F + 0.1F;
			final float dZ = rand.nextFloat() * 0.8F + 0.1F;

			final EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + dX, pos.func_177956_o() + dY, pos.func_177952_p() + dZ,
					itemStack.func_77946_l());

			if (itemStack.func_77942_o()) {
				entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
			}

			final float factor = 0.05F;
			entityItem.field_70159_w = rand.nextGaussian() * factor;
			entityItem.field_70181_x = rand.nextGaussian() * factor + 0.2F;
			entityItem.field_70179_y = rand.nextGaussian() * factor;
			world.func_72838_d(entityItem);
			itemStack.field_77994_a = (0);
		}
	}

	@Override
	public TileEntity func_149915_a(final World p_149915_1_, final int p_149915_2_) {
		return new TileQuantumChest();
	}

	@Override
	public boolean func_180639_a(final World worldIn, final BlockPos pos, final IBlockState state, final EntityPlayer playerIn,
			final EnumHand hand, ItemStack stack, final EnumFacing side, final float hitX, final float hitY, final float hitZ) {
		if (!playerIn.func_70093_af())
			playerIn.openGui(Core.INSTANCE, EGui.QUANTUM_CHEST.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
		return true;
	}

	@Override
	public String getFront(final boolean isActive) {
		return this.prefix + "quantum_chest";
	}

	@Override
	public String getSide(final boolean isActive) {
		return this.prefix + "qchest_side";
	}

	@Override
	public String getTop(final boolean isActive) {
		return this.prefix + "quantum_top";
	}

	@Override
	public String getBottom(final boolean isActive) {
		return this.prefix + "machine_bottom";
	}
}
