package techreborn.blocks;

import me.modmuss50.jsonDestroyer.api.IOpaqueBlock;
import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.RebornCore;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModBlocks;

import java.util.List;
import java.util.Random;

/**
 * Created by modmuss50 on 20/02/2016.
 */
public class BlockRubberLeaves extends BlockLeaves implements ITexturedBlock, IOpaqueBlock {

	public BlockRubberLeaves() {
		super();
		func_149663_c("techreborn.rubberleaves");
		func_149647_a(TechRebornCreativeTabMisc.instance);
		RebornCore.jsonDestroyer.registerObject(this);
		this.func_180632_j(this.func_176223_P().func_177226_a(field_176236_b, true)
			.func_177226_a(field_176237_a, true));
		Blocks.field_150480_ab.func_180686_a(this, 30, 60);
	}

	@Override
	public BlockPlanks.EnumType func_176233_b(int meta) {
		return null;
	}

	@Override
	public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
		List<ItemStack> list = new java.util.ArrayList<>();
		list.add(new ItemStack(this, 1, 0));
		return list;
	}

	@Override
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.CUTOUT_MIPPED;
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	public boolean isFullCube() {
		return false;
	}

	//TODO 1.11: what is this?
	//	@Override
	//	protected ItemStack createStackedBlock(IBlockState state) {
	//		IBlockState newState = state.withProperty(CHECK_DECAY, false).withProperty(DECAYABLE,
	//			false);
	//
	//		return super.createStackedBlock(newState);
	//	}

	@Override
	public String getTextureNameFromState(IBlockState IBlockState, EnumFacing enumFacing) {
		return "techreborn:blocks/rubber_leaves";
	}

	@Override
	public int amountOfStates() {
		return 4;
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, new IProperty[] { field_176236_b, field_176237_a });
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return this.func_176223_P().func_177226_a(field_176237_a, (meta & 1) == 0)
			.func_177226_a(field_176236_b, (meta & 2) > 0);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		int meta = 0;
		if (!(Boolean) state.func_177229_b(field_176237_a)) {
			meta |= 1;
		}
		if ((Boolean) state.func_177229_b(field_176236_b)) {
			meta |= 2;
		}
		return meta;
	}

	@SideOnly(Side.CLIENT)
	public int getBlockColor() {
		return 16777215;
	}

	@SideOnly(Side.CLIENT)
	public int getRenderColor(IBlockState state) {
		return 16777215;
	}

	@SideOnly(Side.CLIENT)
	public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
		return 16777215;
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return Item.func_150898_a(ModBlocks.RUBBER_SAPLING);
	}
}
