package techreborn.blocks;

import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.world.RubberTreeGenerator;

import java.util.Random;

/**
 * Created by modmuss50 on 20/02/2016.
 */
public class BlockRubberSapling extends BlockSapling {

	public BlockRubberSapling() {
		func_149663_c("techreborn.rubbersapling");
		func_149647_a(TechRebornCreativeTabMisc.instance);
		this.func_180632_j(this.func_176223_P().func_177226_a(field_176479_b, 0));
		func_149672_a(SoundType.field_185850_c);
	}

	@Override
	public void func_176476_e(World worldIn, BlockPos pos, IBlockState state, Random rand) {
		if (!net.minecraftforge.event.terraingen.TerrainGen.saplingGrowTree(worldIn, rand, pos)) {
			return;
		}
		worldIn.func_175698_g(pos);
		if (!new RubberTreeGenerator(false).growTree(worldIn, rand, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
			worldIn.func_175656_a(pos, state); // Re-add the sapling if the tree
			// failed to grow
		}
	}

	@Override
	public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
		list.add(new ItemStack(itemIn, 1, 0));
	}
}
