package techreborn.blocks;

import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.BaseBlock;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModBlocks;

import java.util.Random;

public class BlockStorage extends BaseBlock implements ITexturedBlock {

	public static final String[] types = new String[] { "silver", "aluminum", "titanium", "chrome", "steel", "brass",
		"lead", "electrum", "zinc", "platinum", "tungsten", "nickel", "invar", "iridium" };
	public PropertyInteger METADATA;

	public BlockStorage(Material material) {
		super(material);
		func_149663_c("techreborn.storage");
		func_149647_a(TechRebornCreativeTabMisc.instance);
		func_149711_c(2f);
		this.func_180632_j(this.func_176223_P().func_177226_a(METADATA, 0));
	}

	public static ItemStack getStorageBlockByName(String name, int count) {
		for (int i = 0; i < types.length; i++) {
			if (types[i].equals(name)) {
				return new ItemStack(ModBlocks.STORAGE, count, i);
			}
		}
		return BlockStorage2.getStorageBlockByName(name, count);
	}

	public static ItemStack getStorageBlockByName(String name) {
		return getStorageBlockByName(name, 1);
	}

	@Override
	public Item func_180660_a(IBlockState state, Random rand, int fortune) {
		return Item.func_150898_a(this);
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
		for (int meta = 0; meta < types.length; meta++) {
			list.add(new ItemStack(item, 1, meta));
		}
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@Override
	public String getTextureNameFromState(IBlockState BlockStateContainer, EnumFacing facing) {
		return "techreborn:blocks/storage/" + types[func_176201_c(BlockStateContainer)] + "_block";
	}

	@Override
	public int amountOfStates() {
		return types.length;
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		if (meta > types.length) {
			meta = 0;
		}
		return this.func_176223_P().func_177226_a(METADATA, meta);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(METADATA);
	}

	protected BlockStateContainer func_180661_e() {

		METADATA = PropertyInteger.func_177719_a("type", 0, types.length - 1);
		return new BlockStateContainer(this, METADATA);
	}

}
