package techreborn.blocks.generator;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.BaseTileBlock;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.generator.TileSolarPanel;

/**
 * Created by modmuss50 on 25/02/2016.
 */
public class BlockSolarPanel extends BaseTileBlock {

	public static PropertyBool ACTIVE = PropertyBool.func_177716_a("active");
	private final String prefix = "techreborn:blocks/machine/generators/";

	public BlockSolarPanel() {
		super(Material.field_151573_f);
		func_149663_c("techreborn.solarpanel");
		func_149647_a(TechRebornCreativeTab.instance);
		this.func_180632_j(this.func_176223_P().func_177226_a(ACTIVE, false));
		func_149711_c(2.0F);
	}

	protected BlockStateContainer func_180661_e() {
		ACTIVE = PropertyBool.func_177716_a("active");
		return new BlockStateContainer(this, ACTIVE);
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(ACTIVE, meta != 0);
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(ACTIVE) ? 1 : 0;
	}

	@Override
	public TileEntity func_149915_a(World worldIn, int meta) {
		return new TileSolarPanel();
	}

	@Override
	public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
		if (worldIn.func_175710_j(pos.func_177984_a()) && !worldIn.func_72896_J() && !worldIn.func_72911_I()
			&& worldIn.func_72935_r()) {
			worldIn.func_175656_a(pos,
				worldIn.func_180495_p(pos).func_177226_a(BlockSolarPanel.ACTIVE, true));
		} else {

			worldIn.func_175656_a(pos,
				worldIn.func_180495_p(pos).func_177226_a(BlockSolarPanel.ACTIVE, false));
		}
	}

	@Override
	public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY,
	                                        float hitZ, int meta, EntityLivingBase placer) {
		if (!worldIn.field_72995_K) {
			if (worldIn.func_175710_j(pos.func_177984_a()) && !worldIn.func_72896_J() && !worldIn.func_72911_I() && worldIn.func_72935_r()) {
				return this.func_176223_P().func_177226_a(ACTIVE, true);

			} else {
				return this.func_176223_P().func_177226_a(ACTIVE, false);
			}
		} else {
			return this.func_176223_P().func_177226_a(ACTIVE, false);
		}
	}

}
