package techreborn.blocks.machine;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IAdvancedRotationTexture;

import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.multiblock.TileVacuumFreezer;

import javax.annotation.Nullable;

public class BlockVacuumFreezer extends BlockMachineBase implements IAdvancedRotationTexture {

	private final String prefix = "techreborn:blocks/machine/greg_machines/";

	public BlockVacuumFreezer(final Material material) {
		super();
		this.func_149663_c("techreborn.vacuumfreezer");
		this.func_149647_a(TechRebornCreativeTab.instance);
	}

	@Override
	public TileEntity func_149915_a(final World world, final int meta) {
		return new TileVacuumFreezer();
	}

	@Override
	public boolean func_180639_a(final World world, final BlockPos pos, final IBlockState state, final EntityPlayer player, final EnumHand hand, @Nullable
		ItemStack heldItem, final EnumFacing side, final float hitX, final float hitY, final float hitZ) {
		if (!player.func_70093_af()) {
			player.openGui(Core.INSTANCE, EGui.VACUUM_FREEZER.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
			return true;
		}
		return false;
	}

	@Override
	public String getFront(final boolean isActive) {
		return this.prefix + "vacuum_freezer_front";
	}

	@Override
	public String getSide(final boolean isActive) {
		return this.prefix + "machine_side";
	}

	@Override
	public String getTop(final boolean isActive) {
		return this.prefix + "vacuum_freezer_top";
	}

	@Override
	public String getBottom(final boolean isActive) {
		return this.prefix + "machine_bottom";
	}
}
