package techreborn.blocks.storage;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import techreborn.client.EGui;
import techreborn.tiles.idsu.TileIDSU;

import java.util.ArrayList;
import java.util.List;

public class BlockIDSU extends BlockEnergyStorage {
	public BlockIDSU() {
		super("IDSU", EGui.IDSU.ordinal());
	}

	@Override
	public TileEntity func_149915_a(final World world, final int p_149915_2_) {
		return new TileIDSU();
	}

	@Override
	public IBlockState func_180642_a(final World world, final BlockPos pos, final EnumFacing facing, final float hitX, final float hitY,
			final float hitZ, final int meta, final EntityLivingBase placer) {
		final TileEntity tile = world.func_175625_s(pos);
		if (tile instanceof TileIDSU) {
			((TileIDSU) tile).ownerUdid = placer.func_110124_au().toString();
		}
		return this.func_176223_P();
	}

	@Override
	public List<ItemStack> getDrops(final IBlockAccess world, final BlockPos pos, final IBlockState state, final int fortune) {
		final ArrayList<ItemStack> list = new ArrayList<>();
		list.add(new ItemStack(this, 1, 2));
		return list;
	}
}
