package techreborn.blocks.storage;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import reborncore.common.BaseTileBlock;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.lesu.TileLesuStorage;

import java.util.ArrayList;
import java.util.List;

public class BlockLESUStorage extends BaseTileBlock {;

	public BlockLESUStorage(Material material) {
		super(material);
		func_149663_c("techreborn.lesustorage");
		func_149647_a(TechRebornCreativeTab.instance);
	}

	@Override
	public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
		super.func_180633_a(world, pos, state, player, itemstack);
		if (world.func_175625_s(pos) instanceof TileLesuStorage) {
			((TileLesuStorage) world.func_175625_s(pos)).rebuildNetwork();
		}
	}

	@Override
	public void func_180663_b(World world, BlockPos pos, IBlockState state) {
		if (world.func_175625_s(pos) instanceof TileLesuStorage) {
			((TileLesuStorage) world.func_175625_s(pos)).removeFromNetwork();
		}
		super.func_180663_b(world, pos, state);
	}

	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		List<ItemStack> items = new ArrayList<>();
		items.add(new ItemStack(this));
		return items;
	}

	@Override
	public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
		return new TileLesuStorage();
	}

	public boolean shouldConnectToBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int meta) {
		return block == this;
	}
}
