package techreborn.client.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.common.container.RebornContainer;
import techreborn.tiles.idsu.TileIDSU;

public class ContainerIDSU extends RebornContainer {

	public int euOut;
	public int storedEu;
	public int euChange;
	public int channel;
	EntityPlayer player;
	TileIDSU tile;

	public ContainerIDSU(TileIDSU tileIDSU, EntityPlayer player) {
		tile = tileIDSU;
		this.player = player;

		int i;

		for (i = 0; i < 3; ++i) {
			for (int j = 0; j < 9; ++j) {
				this.func_75146_a(new BaseSlot(player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 115 + i * 18));
			}
		}

		for (i = 0; i < 9; ++i) {
			this.func_75146_a(new BaseSlot(player.field_71071_by, i, 8 + i * 18, 173));
		}
	}

	@Override
	public boolean func_75145_c(EntityPlayer player) {
		return true;
	}

	@Override
	public void func_75142_b() {
		super.func_75142_b();
		for (int i = 0; i < this.field_75149_d.size(); i++) {
			IContainerListener IContainerListener = this.field_75149_d.get(i);
			if (this.euOut != tile.output) {
				IContainerListener.func_71112_a(this, 0, tile.output);
			}
			if (this.storedEu != (int) tile.getEnergy()) {
				IContainerListener.func_71112_a(this, 1, (int) tile.getEnergy());
			}
			if (this.euChange != tile.getEuChange() && tile.getEuChange() != -1) {
				IContainerListener.func_71112_a(this, 2, (int) tile.getEuChange());
			}
		}
	}

	@Override
	public void func_75132_a(IContainerListener crafting) {
		super.func_75132_a(crafting);
		crafting.func_71112_a(this, 0, tile.output);
		crafting.func_71112_a(this, 1, (int) tile.getEnergy());
		crafting.func_71112_a(this, 2, (int) tile.getEuChange());
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_75137_b(int id, int value) {
		if (id == 0) {
			this.euOut = value;
		} else if (id == 1) {
			this.storedEu = value;
		} else if (id == 2) {
			this.euChange = value;
		} else if (id == 3) {
			this.channel = value;
		}
	}

}
