package techreborn.client.container.builder;

import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.*;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import reborncore.common.util.ItemUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;

public class BuiltContainer extends Container {

	private final String name;

	private final Predicate<EntityPlayer> canInteract;
	private final List<Range<Integer>> playerSlotRanges;
	private final List<Range<Integer>> tileSlotRanges;

	private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Short>> shortValues;
	private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Integer>> integerValues;
	private List<Consumer<InventoryCrafting>> craftEvents;
	private Integer[] integerParts;

	public BuiltContainer(final String name, final Predicate<EntityPlayer> canInteract,
			final List<Range<Integer>> playerSlotRange,
			final List<Range<Integer>> tileSlotRange) {
		this.name = name;

		this.canInteract = canInteract;

		this.playerSlotRanges = playerSlotRange;
		this.tileSlotRanges = tileSlotRange;

		this.shortValues = new ArrayList<>();
		this.integerValues = new ArrayList<>();
	}

	public void addShortSync(final List<Pair<IntSupplier, IntConsumer>> syncables) {

		for (final Pair<IntSupplier, IntConsumer> syncable : syncables)
			this.shortValues.add(MutableTriple.of(syncable.getLeft(), syncable.getRight(), (short) 0));
		this.shortValues.trimToSize();
	}

	public void addIntegerSync(final List<Pair<IntSupplier, IntConsumer>> syncables) {

		for (final Pair<IntSupplier, IntConsumer> syncable : syncables)
			this.integerValues.add(MutableTriple.of(syncable.getLeft(), syncable.getRight(), 0));
		this.integerValues.trimToSize();
		this.integerParts = new Integer[this.integerValues.size()];
	}

	public void addCraftEvents(final List<Consumer<InventoryCrafting>> craftEvents) {
		this.craftEvents = craftEvents;
	}

	public void addSlot(final Slot slot) {
		this.func_75146_a(slot);
	}

	@Override
	public boolean func_75145_c(final EntityPlayer playerIn) {
		return this.canInteract.test(playerIn);
	}

	@Override
	public final void func_75130_a(final IInventory inv) {
		if (!this.craftEvents.isEmpty())
			this.craftEvents.forEach(consumer -> consumer.accept((InventoryCrafting) inv));
	}

	@Override
	public void func_75142_b() {
		super.func_75142_b();

		for (final IContainerListener listener : this.field_75149_d) {

			int i = 0;
			if (!this.shortValues.isEmpty())
				for (final MutableTriple<IntSupplier, IntConsumer, Short> value : this.shortValues) {
					final short supplied = (short) value.getLeft().getAsInt();
					if (supplied != value.getRight()) {

						listener.func_71112_a(this, i, supplied);
						value.setRight(supplied);
					}
					i++;
				}

			if (!this.integerValues.isEmpty())
				for (final MutableTriple<IntSupplier, IntConsumer, Integer> value : this.integerValues) {
					final int supplied = value.getLeft().getAsInt();
					if (supplied != value.getRight()) {

						listener.func_71112_a(this, i, supplied >> 16);
						listener.func_71112_a(this, i + 1, (short) (supplied & 0xFFFF));
						value.setRight(supplied);
					}
					i += 2;
				}
		}
	}

	@Override
	public void func_75132_a(final IContainerListener listener) {
		super.func_75132_a(listener);

		int i = 0;
		if (!this.shortValues.isEmpty())
			for (final MutableTriple<IntSupplier, IntConsumer, Short> value : this.shortValues) {
				final short supplied = (short) value.getLeft().getAsInt();

				listener.func_71112_a(this, i, supplied);
				value.setRight(supplied);
				i++;
			}

		if (!this.integerValues.isEmpty())
			for (final MutableTriple<IntSupplier, IntConsumer, Integer> value : this.integerValues) {
				final int supplied = value.getLeft().getAsInt();

				listener.func_71112_a(this, i, supplied >> 16);
				listener.func_71112_a(this, i + 1, (short) (supplied & 0xFFFF));
				value.setRight(supplied);
				i += 2;
			}

	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_75137_b(final int id, final int value) {

		if(id < this.shortValues.size())
		{
			this.shortValues.get(id).getMiddle().accept((short) value);
			this.shortValues.get(id).setRight((short) value);
		}
		else if (id - this.shortValues.size() < this.integerValues.size() * 2)
		{

			if ((id - this.shortValues.size()) % 2 == 0)
				this.integerParts[(id - this.shortValues.size()) / 2] = value;
			else
			{
				this.integerValues.get((id - this.shortValues.size()) / 2).getMiddle().accept(
						(this.integerParts[(id - this.shortValues.size()) / 2] & 0xFFFF) << 16 | value & 0xFFFF);
			}
		}
	}

	@Override
	public ItemStack func_82846_b(final EntityPlayer player, final int index) {

		ItemStack originalStack = null;

		final Slot slot = this.field_75151_b.get(index);

		if (slot != null && slot.func_75216_d()) {

			final ItemStack stackInSlot = slot.func_75211_c();
			originalStack = stackInSlot.func_77946_l();

			boolean shifted = false;

			for (final Range<Integer> range : this.playerSlotRanges)
				if (range.contains(index)) {

					if (this.shiftToTile(stackInSlot))
						shifted = true;
					break;
				}

			if (!shifted)
				for (final Range<Integer> range : this.tileSlotRanges)
					if (range.contains(index)) {
						if (this.shiftToPlayer(stackInSlot))
							shifted = true;
						break;
					}

			slot.func_75220_a(stackInSlot, originalStack);
			if (stackInSlot.field_77994_a <= 0)
				slot.func_75215_d(null);
			else
				slot.func_75218_e();
			if (stackInSlot.field_77994_a == originalStack.field_77994_a)
				return null;
			slot.func_82870_a(player, stackInSlot);
		}
		return originalStack;
	}

	protected boolean shiftItemStack(final ItemStack stackToShift, final int start, final int end) {
		boolean changed = false;
		if (stackToShift.func_77985_e()) {
			for (int slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; slotIndex++) {
				final Slot slot = this.field_75151_b.get(slotIndex);
				final ItemStack stackInSlot = slot.func_75211_c();
				if (stackInSlot != null && ItemUtils.isItemEqual(stackInSlot, stackToShift, true, true)
						&& slot.func_75214_a(stackToShift)) {
					final int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
					final int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
					if (resultingStackSize <= max) {
						stackToShift.field_77994_a = (0);
						stackInSlot.field_77994_a = (resultingStackSize);
						slot.func_75218_e();
						changed = true;
					} else if (stackInSlot.field_77994_a < max) {
						stackToShift.field_77994_a -= (max - stackInSlot.field_77994_a);
						stackInSlot.field_77994_a = (max);
						slot.func_75218_e();
						changed = true;
					}
				}
			}
		}
		if (stackToShift.field_77994_a > 0) {
			for (int slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; slotIndex++) {
				final Slot slot = this.field_75151_b.get(slotIndex);
				ItemStack stackInSlot = slot.func_75211_c();
				if (stackInSlot == null && slot.func_75214_a(stackToShift)) {
					final int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
					stackInSlot = stackToShift.func_77946_l();
					stackInSlot.field_77994_a = (Math.min(stackToShift.field_77994_a, max));
					stackToShift.field_77994_a = (-stackInSlot.field_77994_a);
					slot.func_75215_d(stackInSlot);
					slot.func_75218_e();
					changed = true;
				}
			}
		}
		return changed;
	}

	private boolean shiftToTile(final ItemStack stackToShift) {
		for (final Range<Integer> range : this.tileSlotRanges)
			if (this.shiftItemStack(stackToShift, range.getMinimum(), range.getMaximum() + 1))
				return true;
		return false;
	}

	private boolean shiftToPlayer(final ItemStack stackToShift) {
		for (final Range<Integer> range : this.playerSlotRanges)
			if (this.shiftItemStack(stackToShift, range.getMinimum(), range.getMaximum() + 1))
				return true;
		return false;
	}

	public String getName() {
		return this.name;
	}
}
