package techreborn.client.container.builder.slot;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import java.util.function.Predicate;

public class FilteredSlot extends Slot {

	private Predicate<ItemStack> filter;

	public FilteredSlot(final IInventory inventory, final int index, final int xPosition, final int yPosition) {
		super(inventory, index, xPosition, yPosition);
	}

	public FilteredSlot setFilter(final Predicate<ItemStack> filter) {
		this.filter = filter;
		return this;
	}

	@Override
	public boolean func_75214_a(final ItemStack stack) {
		try {
			return this.filter.test(stack);
		} catch (NullPointerException e) {
			return true;
		}
	}
}
