package techreborn.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import reborncore.common.packets.PacketHandler;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.client.container.ContainerAESU;
import techreborn.packets.PacketAesu;
import techreborn.tiles.TileAesu;

import java.awt.*;
import java.io.IOException;

public class GuiAESU extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/aesu.png");

	TileAesu aesu;

	ContainerAESU containerAesu;

	public GuiAESU(EntityPlayer player, TileAesu tileaesu) {
		super(new ContainerAESU(tileaesu, player));
		this.field_146999_f = 176;
		this.field_147000_g = 197;
		aesu = tileaesu;
		this.containerAesu = (ContainerAESU) this.field_147002_h;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.field_146292_n.clear();
		int k = (this.field_146294_l - this.field_146999_f) / 2;
		int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.field_146292_n.add(new GuiButton(0, k + 115, l + 5, 15, 20, "++"));
		this.field_146292_n.add(new GuiButton(1, k + 115, l + 5 + 20, 15, 20, "+"));
		this.field_146292_n.add(new GuiButton(2, k + 115, l + 5 + (20 * 2), 15, 20, "-"));
		this.field_146292_n.add(new GuiButton(3, k + 115, l + 5 + (20 * 3), 15, 20, "--"));
	}

	@Override
	protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(texture);
		int k = (this.field_146294_l - this.field_146999_f) / 2;
		int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
	}

	protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
		this.field_146289_q.func_78276_b(I18n.func_74838_a("tile.techreborn.aesu.name"), 40, 10,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerAesu.euOut) + " /tick", 10, 20,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerAesu.storedEu) + " ", 10, 30,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerAesu.euChange) + " change", 10, 40,
			Color.WHITE.getRGB());
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		super.func_146284_a(button);
		PacketHandler.sendPacketToServer(new PacketAesu(button.field_146127_k, aesu));
	}
}
