package techreborn.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.gui.widget.GuiButtonPowerBar;

/**
 * Created by Prospector
 */
public class GuiBase extends GuiContainer {

	public int xSize = 176;
	public int ySize = 176;
	public TRBuilder builder = new TRBuilder();
	public TileEntity tile;
	public BuiltContainer container;

	public GuiBase(EntityPlayer player, TileEntity tile, BuiltContainer container) {
		super(container);
		this.tile = tile;
		this.container = container;
	}

	protected void drawSlot(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += field_147003_i;
			y += field_147009_r;
		}
		builder.drawSlot(this, x - 1, y - 1);
	}

	protected void drawArmourSlots(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += field_147003_i;
			y += field_147009_r;
		}
		builder.drawSlot(this, x - 1, y - 1);
		builder.drawSlot(this, x - 1, y - 1 + 18);
		builder.drawSlot(this, x - 1, y - 1 + 18 + 18);
		builder.drawSlot(this, x - 1, y - 1 + 18 + 18 + 18);
	}

	protected void drawOutputSlot(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += field_147003_i;
			y += field_147009_r;
		}
		builder.drawOutputSlot(this, x - 5, y - 5);
	}

	protected void drawSelectedStack(int x, int y, Layer layer) {
		if (layer == Layer.BACKGROUND) {
			x += field_147003_i;
			y += field_147009_r;
		}
		builder.drawSelectedStack(this, x, y);
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
	}

	@Override
	protected void func_146976_a(float p_146976_1_, int mouseX, int mouseY) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		builder.drawDefaultBackground(this, field_147003_i, field_147009_r, xSize, ySize);
		builder.drawPlayerSlots(this, field_147003_i + xSize / 2, field_147009_r + 93, true);
	}

	@SideOnly(Side.CLIENT)
	@Override
	protected void func_146979_b(int mouseX, int mouseY) {
		drawTitle();
	}

	protected void drawTitle() {
		drawCentredString(I18n.func_74838_a(tile.func_145838_q().func_149739_a() + ".name"), 6, 4210752, Layer.FOREGROUND);
	}

	protected void drawCentredString(String string, int y, int colour, Layer layer) {
		drawString(string, (xSize / 2 - field_146297_k.field_71466_p.func_78256_a(string) / 2), y, colour, layer);
	}

	protected void drawCentredString(String string, int y, int colour, int modifier, Layer layer) {
		drawString(string, (xSize / 2 - (field_146297_k.field_71466_p.func_78256_a(string)) / 2) + modifier, y, colour, layer);
	}

	protected void drawString(String string, int x, int y, int colour, Layer layer) {
		int factorX = 0;
		int factorY = 0;
		if (layer == Layer.BACKGROUND) {
			factorX = field_147003_i;
			factorY = field_147009_r;
		}
		field_146297_k.field_71466_p.func_78276_b(string, x + factorX, y + factorY, colour);
		GlStateManager.func_179131_c(1, 1, 1, 1);
	}

	public void addPowerButton(int x, int y, int id, Layer layer) {
		if (id == 0)
			field_146292_n.clear();
		int factorX = 0;
		int factorY = 0;
		if (layer == Layer.BACKGROUND) {
			factorX = field_147003_i;
			factorY = field_147009_r;
		}
		field_146292_n.add(new GuiButtonPowerBar(id, x + factorX, y + factorY, this, layer));
	}

	//TODO
	public enum SlotRender {
		STANDARD, OUTPUT, NONE, SPRITE;

	}

	public enum Layer {
		BACKGROUND, FOREGROUND
	}
}
