package techreborn.client.gui;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.common.misc.Location;
import techreborn.client.gui.widget.GuiButtonHologram;
import techreborn.init.ModBlocks;
import techreborn.proxies.ClientProxy;
import techreborn.tiles.multiblock.TileBlastFurnace;

import java.io.IOException;

import techreborn.client.gui.GuiBase.Layer;

public class GuiBlastFurnace extends GuiBase {

	public TileBlastFurnace tile;
	boolean hasMultiBlock;

	public GuiBlastFurnace(final EntityPlayer player, final TileBlastFurnace tile) {
		super(player, tile, tile.createContainer(player));
		this.tile = tile;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		this.hasMultiBlock = this.tile.getCachedHeat() != 0;
		ClientProxy.multiblockRenderEvent.setMultiblock(null);
	}

	@Override
	protected void func_146976_a(final float f, final int mouseX, final int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);
		this.hasMultiBlock = this.tile.getCachedHeat() != 0;

		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		final GuiBase.Layer layer = Layer.BACKGROUND;

		drawSlot(50, 27, layer);
		drawSlot(50, 47, layer);
		drawSlot(92, 36, layer);
		drawSlot(110, 36, layer);

		this.builder.drawJEIButton(this, 150, 4, layer);
	}

	@Override
	protected void func_146979_b(final int mouseX, final int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		this.hasMultiBlock = this.tile.getCachedHeat() != 0;
		final GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;

		this.builder.drawProgressBar(this, this.tile.getProgressScaled(100), 100, 71, 40, mouseX, mouseY, TRBuilder.ProgressDirection.RIGHT, layer);
		this.builder.drawMultiEnergyBar(this, 9, 18, (int) this.tile.getEnergy(), (int) this.tile.getMaxPower(), mouseX, mouseY, 0, layer);
		this.builder.drawBigHeatBar(this, 31, 71, tile.getCachedHeat(), 3230, layer);
		if (hasMultiBlock) {
			addHologramButton(6, 4, 212, layer);
			builder.drawHologramButton(this, 6, 4, mouseX, mouseY, layer);
		} else {
			builder.drawMultiblockMissingBar(this, layer);
			addHologramButton(76, 56, 212, layer);
			builder.drawHologramButton(this, 76, 56, mouseX, mouseY, layer);
		}
	}

	public void addHologramButton(int x, int y, int id, Layer layer) {
		if (id == 0)
			field_146292_n.clear();
		int factorX = 0;
		int factorY = 0;
		if (layer == Layer.BACKGROUND) {
			factorX = field_147003_i;
			factorY = field_147009_r;
		}
		field_146292_n.add(new GuiButtonHologram(id, x + factorX, y + factorY, this, layer));
	}

	@Override
	public void func_146284_a(final GuiButton button) throws IOException {
		super.func_146284_a(button);
		if (button.field_146127_k == 212) {
			if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
				{
					// This code here makes a basic multiblock and then sets to the selected one.
					final Multiblock multiblock = new Multiblock();
					this.addComponent(0, 0, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 0, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 0, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 0, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 0, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 0, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 0, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 0, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 0, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					this.addComponent(1, 1, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 1, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 1, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 1, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 1, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 1, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 1, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 1, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					this.addComponent(1, 2, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 2, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 2, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 2, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 2, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 2, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 2, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 2, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					this.addComponent(0, 3, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 3, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 3, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 3, 0, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(0, 3, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 3, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(-1, 3, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 3, -1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);
					this.addComponent(1, 3, 1, ModBlocks.MACHINE_CASINGS.func_176223_P(), multiblock);

					final MultiblockSet set = new MultiblockSet(multiblock);
					ClientProxy.multiblockRenderEvent.setMultiblock(set);
					ClientProxy.multiblockRenderEvent.parent = new Location(this.tile.func_174877_v().func_177958_n(),
						this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), this.tile.func_145831_w());
					MultiblockRenderEvent.anchor = new BlockPos(
						this.tile.func_174877_v().func_177958_n()
							- EnumFacing.func_82600_a(this.tile.getFacingInt()).func_82601_c() * 2,
						this.tile.func_174877_v().func_177956_o() - 1, this.tile.func_174877_v().func_177952_p()
						- EnumFacing.func_82600_a(this.tile.getFacingInt()).func_82599_e() * 2);
				}
			} else {
				ClientProxy.multiblockRenderEvent.setMultiblock(null);
			}
		}
	}

	public void addComponent(final int x, final int y, final int z, final IBlockState blockState, final Multiblock multiblock) {
		multiblock.addComponent(new BlockPos(x, y, z), blockState);
	}

}
