package techreborn.client.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

import techreborn.tiles.TileDigitalChest;

import techreborn.client.gui.GuiBase.Layer;

public class GuiDigitalChest extends GuiBase {

	TileDigitalChest digitalChest;

	public GuiDigitalChest(final EntityPlayer player, final TileDigitalChest digitalChest) {
		super(player, digitalChest, digitalChest.createContainer(player));
		this.digitalChest = digitalChest;
	}

	@Override
	protected void func_146976_a(final float f, final int mouseX, final int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		this.drawSlot(80, 24, layer);
		this.drawSlot(80, 64, layer);
	}

	@Override
	protected void func_146979_b(final int mouseX, final int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		final Layer layer = Layer.FOREGROUND;

		if (this.digitalChest.storedItem != null && this.digitalChest.func_70301_a(1) != null) {
			this.builder.drawBigBlueBar(this, 31, 43,
					this.digitalChest.storedItem.field_77994_a + this.digitalChest.func_70301_a(1).field_77994_a,
					this.digitalChest.maxCapacity, mouseX - this.field_147003_i, mouseY - this.field_147009_r, "Stored", layer);
		}
		if (this.digitalChest.storedItem == null && this.digitalChest.func_70301_a(1) != null) {
			this.builder.drawBigBlueBar(this, 31, 43, this.digitalChest.func_70301_a(1).field_77994_a,
					this.digitalChest.maxCapacity, mouseX - this.field_147003_i, mouseY - this.field_147009_r, "Stored", layer);
		}
	}
}
