package techreborn.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;

import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.common.misc.Location;
import reborncore.common.powerSystem.PowerSystem;

import techreborn.client.ClientMultiBlocks;
import techreborn.proxies.ClientProxy;
import techreborn.tiles.fusionReactor.TileEntityFusionController;

import java.io.IOException;

public class GuiFusionReactor extends GuiContainer {

	public static final ResourceLocation texture = new ResourceLocation("techreborn",
			"textures/gui/fusion_reactor.png");

	TileEntityFusionController fusionController;

	public GuiFusionReactor(final EntityPlayer player, final TileEntityFusionController fusion) {
		super(fusion.createContainer(player));
		this.fusionController = fusion;
	}

	@Override
	protected void func_146979_b(final int p_146979_1_, final int p_146979_2_) {
		final String name = I18n.func_74838_a("tile.techreborn.fusioncontrolcomputer.name");
		this.field_146289_q.func_78276_b(name, 87, 6, 4210752);
		this.field_146289_q.func_78276_b(I18n.func_74837_a("container.inventory", new Object[0]), 8,
				this.field_147000_g - 96 + 2, 4210752);

		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(this.fusionController.getEnergy()), 11, 8,
				16448255);
		this.field_146289_q.func_78276_b("Coils: " + (this.fusionController.getCoilStatus() == 1 ? "Yes" : "No"), 11, 16,
				16448255);
		if (this.fusionController.getNeededPower() > 1 && this.fusionController.getCrafingTickTime() < 1)
			this.field_146289_q.func_78276_b("Start: "
					+ this.percentage(this.fusionController.getNeededPower(), (int) this.fusionController.getEnergy())
					+ "%", 11, 24, 16448255);

	}

	@Override
	public void func_73866_w_() {
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		final GuiButton button = new GuiButton(212, k + this.field_146999_f - 24, l + 4, 20, 20, "");
		this.field_146292_n.add(button);
		super.func_73866_w_();
		final BlockPos coordinates = new BlockPos(
				this.fusionController.func_174877_v().func_177958_n()
				- EnumFacing.func_82600_a(this.fusionController.getFacingInt()).func_82601_c() * 2,
				this.fusionController.func_174877_v().func_177956_o() - 1, this.fusionController.func_174877_v().func_177952_p()
				- EnumFacing.func_82600_a(this.fusionController.getFacingInt()).func_82599_e() * 2);
		if (coordinates.equals(MultiblockRenderEvent.anchor)) {
			ClientProxy.multiblockRenderEvent.setMultiblock(null);
			button.field_146126_j = "B";
		} else {
			button.field_146126_j = "A";
		}
	}

	@Override
	protected void func_146976_a(final float p_146976_1_, final int p_146976_2_,
			final int p_146976_3_) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(GuiFusionReactor.texture);
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);

		this.func_73729_b(k + 88, l + 36, 176, 0, 14, 14);

		// progressBar
		this.func_73729_b(k + 111, l + 34, 176, 14, this.fusionController.getProgressScaled(), 16);

	}

	public int percentage(final int MaxValue, final int CurrentValue) {
		if (CurrentValue == 0)
			return 0;
		return (int) (CurrentValue * 100.0f / MaxValue);
	}

	@Override
	public void func_146284_a(final GuiButton button) throws IOException {
		super.func_146284_a(button);
		if (button.field_146127_k == 212) {
			if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
				// This code here makes a basic multiblock and then sets to
				// theselected one.
				final MultiblockSet set = new MultiblockSet(ClientMultiBlocks.reactor);
				ClientProxy.multiblockRenderEvent.setMultiblock(set);
				ClientProxy.multiblockRenderEvent.parent = new Location(this.fusionController.func_174877_v().func_177958_n(),
						this.fusionController.func_174877_v().func_177956_o(), this.fusionController.func_174877_v().func_177952_p(),
						this.fusionController.func_145831_w());
				MultiblockRenderEvent.anchor = new BlockPos(this.fusionController.func_174877_v().func_177958_n(),
						this.fusionController.func_174877_v().func_177956_o() - 1, this.fusionController.func_174877_v().func_177952_p());

				button.field_146126_j = "A";
			} else {
				ClientProxy.multiblockRenderEvent.setMultiblock(null);
				button.field_146126_j = "B";
			}
		}
	}
}
