package techreborn.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

import techreborn.tiles.multiblock.TileImplosionCompressor;

public class GuiImplosionCompressor extends GuiContainer {

	public static final ResourceLocation texture = new ResourceLocation("techreborn",
			"textures/gui/implosion_compressor.png");

	TileImplosionCompressor compressor;

	public GuiImplosionCompressor(final EntityPlayer player, final TileImplosionCompressor compressor) {
		super(compressor.createContainer(player));
		this.field_146999_f = 176;
		this.field_147000_g = 167;
		this.compressor = compressor;
	}

	@Override
	public void func_73866_w_() {
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		super.func_73866_w_();
	}

	@Override
	protected void func_146976_a(final float p_146976_1_, final int p_146976_2_, final int p_146976_3_) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(GuiImplosionCompressor.texture);
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);

		if (!this.compressor.getMutliBlock()) {
			// GuiDraw.drawTooltipBox(k + 30, l + 50 + 12 - 0, 114, 10);
			this.field_146289_q.func_78276_b(I18n.func_74838_a("techreborn.message.missingmultiblock"), k + 38, l + 52 + 12, -1);
		}

		this.field_146297_k.func_110434_K().func_110577_a(GuiImplosionCompressor.texture);
		int j = this.compressor.getProgressScaled(24);
		if (j > 0) {
			this.func_73729_b(k + 61, l + 37, 176, 14, j + 1, 16);
		}

		j = this.compressor.getEnergyScaled(12);
		if (j > 0) {
			this.func_73729_b(k + 14, l + 36 + 12 - j, 176, 12 - j, 14, j + 2);
		}
	}

	@Override
	protected void func_146979_b(final int p_146979_1_, final int p_146979_2_) {
		final String name = I18n.func_74838_a("tile.techreborn.implosioncompressor.name");
		this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 4210752);
		this.field_146289_q.func_78276_b(I18n.func_74837_a("container.inventory", new Object[0]), 8, this.field_147000_g - 96 + 2, 4210752);
	}

}
