package techreborn.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;

import techreborn.tiles.multiblock.TileIndustrialSawmill;

public class GuiIndustrialSawmill extends GuiContainer {

	public static final ResourceLocation texture = new ResourceLocation("techreborn",
			"textures/gui/industrial_sawmill.png");

	TileIndustrialSawmill sawmill;

	public GuiIndustrialSawmill(final EntityPlayer player, final TileIndustrialSawmill sawmill) {
		super(sawmill.createContainer(player));
		this.field_146999_f = 176;
		this.field_147000_g = 167;
		this.sawmill = sawmill;
	}

	@Override
	public void func_73866_w_() {
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;
		super.func_73866_w_();
	}

	@Override
	protected void func_146976_a(final float p_146976_1_, final int p_146976_2_, final int p_146976_3_) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(GuiIndustrialSawmill.texture);
		final int k = (this.field_146294_l - this.field_146999_f) / 2;
		final int l = (this.field_146295_m - this.field_147000_g) / 2;

		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);

		final int progress = this.sawmill.getProgressScaled(24);
		this.func_73729_b(k + 56, l + 38, 176, 14, progress - 1, 11);

		final int energy = 13 - (int) (this.sawmill.getEnergy() / this.sawmill.getMaxPower() * 13F);
		this.func_73729_b(k + 36, l + 66 + energy, 179, 1 + energy, 7, 13 - energy);

		if (!this.sawmill.tank.isEmpty()) {
			this.drawFluid(this.sawmill.tank.getFluid(), k + 11, l + 66, 12, 47, this.sawmill.tank.getCapacity());

			final int j = this.sawmill.getEnergyScaled(12);
			if (j > 0) {
				this.func_73729_b(k + 33, l + 65 + 12 - j, 176, 12 - j, 14, j + 2);
			}

			if (!this.sawmill.getMutliBlock()) {
				//GuiUtil.drawTooltipBox(k + 30, l + 50 + 12, 114, 10);
				this.field_146289_q.func_78276_b(I18n.func_74838_a("techreborn.message.missingmultiblock"), k + 38,
						l + 52 + 12, -1);
			}
		}
	}

	public void drawFluid(final FluidStack fluid, final int x, final int y, final int width, final int height, final int maxCapacity) {
		this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
		final ResourceLocation still = fluid.getFluid().getStill(fluid);
		final TextureAtlasSprite sprite = this.field_146297_k.func_147117_R().func_110572_b(still.toString());

		final int drawHeight = (int) (fluid.amount / (maxCapacity * 1F) * height);
		final int iconHeight = sprite.func_94216_b();
		int offsetHeight = drawHeight;

		int iteration = 0;
		while (offsetHeight != 0) {
			final int curHeight = offsetHeight < iconHeight ? offsetHeight : iconHeight;
			this.func_175175_a(x, y - offsetHeight, sprite, width, curHeight);
			offsetHeight -= curHeight;
			iteration++;
			if (iteration > 50)
				break;
		}

	}

	@Override
	protected void func_146979_b(final int p_146979_1_, final int p_146979_2_) {
		final String name = I18n.func_74838_a("tile.techreborn.industrialsawmill.name");
		this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 4210752);
		this.field_146289_q.func_78276_b(I18n.func_74837_a("container.inventory"), 58, this.field_147000_g - 96 + 2, 4210752);
	}

}
