package techreborn.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.client.container.ContainerLESU;
import techreborn.tiles.lesu.TileLesu;

import java.awt.*;

public class GuiLESU extends GuiContainer {

	private static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/aesu.png");

	TileLesu aesu;

	ContainerLESU containerLesu;

	public GuiLESU(EntityPlayer player, TileLesu tileaesu) {
		super(new ContainerLESU(tileaesu, player));
		this.field_146999_f = 176;
		this.field_147000_g = 197;
		aesu = tileaesu;
		this.containerLesu = (ContainerLESU) this.field_147002_h;
	}

	@Override
	protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		this.field_146297_k.func_110434_K().func_110577_a(texture);
		int k = (this.field_146294_l - this.field_146999_f) / 2;
		int l = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
	}

	protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
		this.field_146289_q.func_78276_b(I18n.func_74838_a("tile.techreborn.lesu.name"), 40, 10,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerLesu.euOut) + "/t", 10, 20,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerLesu.storedEu), 10, 30,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerLesu.euChange) + " change", 10, 40,
			Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(containerLesu.connectedBlocks + " blocks", 10, 50, Color.WHITE.getRGB());
		this.field_146289_q.func_78276_b(PowerSystem.getLocaliszedPower(containerLesu.euStorage) + " max", 10, 60,
			Color.WHITE.getRGB());
	}

}
