package techreborn.client.gui;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.tiles.storage.TileMFE;

import techreborn.client.gui.GuiBase.Layer;

public class GuiMFE extends GuiBase {

	TileMFE mfe;

	public GuiMFE(final EntityPlayer player, final TileMFE mfe) {
		super(player, mfe, mfe.createContainer(player));
		this.mfe = mfe;
	}

	@Override
	protected void func_146976_a(final float f, final int mouseX, final int mouseY) {
		super.func_146976_a(f, mouseX, mouseY);
		final Layer layer = Layer.BACKGROUND;

		this.drawSlot(62, 45, layer);
		this.drawSlot(98, 45, layer);
		this.drawArmourSlots(8, 18, layer);
	}

	@Override
	protected void func_146979_b(final int mouseX, final int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		final Layer layer = Layer.FOREGROUND;

		GlStateManager.func_179094_E();
		GlStateManager.func_179139_a(0.6, 0.6, 1);
		this.drawCentredString(PowerSystem.getLocaliszedPowerFormattedNoSuffix((int) this.mfe.getEnergy()) + "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix((int) this.mfe.getMaxPower()) + " " + PowerSystem.getDisplayPower().abbreviation, 35, 0, 58, layer);
		GlStateManager.func_179121_F();

		this.builder.drawMultiEnergyBar(this, 81, 28, (int) this.mfe.getEnergy(), (int) this.mfe.getMaxPower(), mouseX, mouseY, 0, layer);
	}
}
