package techreborn.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.lib.ModInfo;
import techreborn.proxies.ClientProxy;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Prospector
 */
public class TRBuilder extends GuiBuilder {
	public static final ResourceLocation GUI_SHEET = new ResourceLocation(ModInfo.MOD_ID.toLowerCase() + ":" + "textures/gui/gui_sheet.png");

	public TRBuilder() {
		super(GUI_SHEET);
	}

	public void drawMultiEnergyBar(GuiBase gui, int x, int y, int energyStored, int maxEnergyStored, int mouseX, int mouseY, int buttonID, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		if (layer == GuiBase.Layer.FOREGROUND) {
			mouseX -= gui.field_147003_i;
			mouseY -= gui.field_147009_r;
		}
		Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_SHEET);

		gui.func_73729_b(x, y, PowerSystem.getDisplayPower().xBar - 15, PowerSystem.getDisplayPower().yBar - 1, 14, 50);

		int draw = (int) ((double) energyStored / (double) maxEnergyStored * (48));
		if (energyStored > maxEnergyStored) {
			draw = (int) ((double) maxEnergyStored / (double) maxEnergyStored * (48));
		}
		gui.func_73729_b(x + 1, y + 49 - draw, PowerSystem.getDisplayPower().xBar, 48 + PowerSystem.getDisplayPower().yBar - draw, 12, draw);
		int percentage = percentage(maxEnergyStored, energyStored);
		if (isInRect(x + 1, y + 1, 11, 48, mouseX, mouseY)) {
			GlStateManager.func_179140_f();
			GlStateManager.func_179097_i();
			GlStateManager.func_179135_a(true, true, true, false);
			GuiUtils.drawGradientRect(0, x + 1, y + 1, x + 13, y + 49, 0x80FFFFFF, 0x80FFFFFF);
			GlStateManager.func_179135_a(true, true, true, true);
			GlStateManager.func_179126_j();

			List<String> list = new ArrayList<>();
			TextFormatting powerColour = TextFormatting.GOLD;
			list.add(powerColour + PowerSystem.getLocaliszedPowerFormattedNoSuffix(energyStored) + "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix(maxEnergyStored) + " " + PowerSystem.getDisplayPower().abbreviation);
			list.add(getPercentageColour(percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Charged");
			net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(list, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1, gui.field_146297_k.field_71466_p);
			GlStateManager.func_179140_f();
			GlStateManager.func_179131_c(1, 1, 1, 1);
		}
		gui.addPowerButton(x, y, buttonID, layer);
	}

	public void drawProgressBar(GuiBase gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, ProgressDirection direction, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		if (layer == GuiBase.Layer.FOREGROUND) {
			mouseX -= gui.field_147003_i;
			mouseY -= gui.field_147009_r;
		}

		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(x, y, direction.x, direction.y, direction.width, direction.height);

		if (direction.equals(ProgressDirection.RIGHT)) {
			int j = (int) ((double) progress / (double) maxProgress * 16);
			if (j < 0)
				j = 0;
			gui.func_73729_b(x, y, direction.xActive, direction.yActive, j, 10);
		}

		if (direction.equals(ProgressDirection.LEFT)) {
			int j = (int) ((double) progress / (double) maxProgress * 16);
			if (j < 0)
				j = 0;
			gui.func_73729_b(x + 16 - j, y, direction.xActive + 16 - j, direction.yActive, j, 10);
		}

		if (isInRect(x, y, direction.width, direction.height, mouseX, mouseY)) {
			int percentage = percentage(maxProgress, progress);
			List<String> list = new ArrayList<>();
			list.add(getPercentageColour(percentage) + "" + percentage + "%");
			net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(list, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1, gui.field_146297_k.field_71466_p);
			GlStateManager.func_179140_f();
			GlStateManager.func_179131_c(1, 1, 1, 1);
		}
	}

	public void drawTank(GuiBase gui, int x, int y, int mouseX, int mouseY, FluidStack fluid, int maxCapacity, boolean isTankEmpty, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		if (layer == GuiBase.Layer.FOREGROUND) {
			mouseX -= gui.field_147003_i;
			mouseY -= gui.field_147009_r;
		}
		int percentage = 0;
		int amount = 0;
		boolean empty = true;
		if (!isTankEmpty) {
			amount = fluid.amount;
			percentage = percentage(maxCapacity, amount);
			empty = false;
		}
		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(x, y, 228, 18, 22, 56);
		if (!empty)
			drawFluid(gui, fluid, x + 4, y + 4, 14, 48, maxCapacity);
		gui.func_73729_b(x + 3, y + 3, 231, 74, 16, 50);

		if (isInRect(x, y, 22, 56, mouseX, mouseY)) {
			List<String> list = new ArrayList<>();
			if (empty)
				list.add(TextFormatting.GOLD + "Empty Tank");
			else
				list.add(TextFormatting.GOLD + "" + amount + "mB/" + maxCapacity + "mB " + fluid.getLocalizedName());
			list.add(getPercentageColour(percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Full");
			net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(list, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1, gui.field_146297_k.field_71466_p);
			GlStateManager.func_179140_f();
			GlStateManager.func_179131_c(1, 1, 1, 1);
		}
	}

	public void drawFluid(GuiBase gui, FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
		gui.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
		y += height;
		final ResourceLocation still = fluid.getFluid().getStill(fluid);
		final TextureAtlasSprite sprite = gui.field_146297_k.func_147117_R().func_110572_b(still.toString());

		final int drawHeight = (int) (fluid.amount / (maxCapacity * 1F) * height);
		final int iconHeight = sprite.func_94216_b();
		int offsetHeight = drawHeight;

		int iteration = 0;
		while (offsetHeight != 0) {
			final int curHeight = offsetHeight < iconHeight ? offsetHeight : iconHeight;
			gui.func_175175_a(x, y - offsetHeight, sprite, width, curHeight);
			offsetHeight -= curHeight;
			iteration++;
			if (iteration > 50)
				break;
		}
		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
	}

	public void drawJEIButton(GuiBase gui, int x, int y, GuiBase.Layer layer) {
		if (Loader.isModLoaded("JEI")) {
			if (layer == GuiBase.Layer.BACKGROUND) {
				x += gui.field_147003_i;
				y += gui.field_147009_r;
			}
			gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
			gui.func_73729_b(x, y, 184, 70, 20, 12);
		}
	}

	public void drawHologramButton(GuiBase gui, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		if (layer == GuiBase.Layer.FOREGROUND) {
			mouseX -= gui.field_147003_i;
			mouseY -= gui.field_147009_r;
		}
		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
			gui.func_73729_b(x, y, 184, 94, 20, 12);
		} else {
			gui.func_73729_b(x, y, 184, 106, 20, 12);
		}
		if (isInRect(x, y, 20, 12, mouseX, mouseY)) {
			List<String> list = new ArrayList<>();
			list.add("Toggle Multiblock Hologram");
			GlStateManager.func_179094_E();
			net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(list, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1, gui.field_146297_k.field_71466_p);
			GlStateManager.func_179121_F();
		}
	}

	public void drawBigBlueBar(GuiBase gui, int x, int y, int value, int max, int mouseX, int mouseY, String suffix, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		if (!suffix.equals("")) {
			suffix = " " + suffix;
		}
		gui.func_73729_b(x, y, 0, 218, 114, 18);
		int j = (int) ((double) value / (double) max * 106);
		if (j < 0)
			j = 0;
		gui.func_73729_b(x + 4, y + 4, 0, 236, j, 10);
		gui.drawCentredString(value + suffix, y + 5, 0xFFFFFF, layer);
		if (isInRect(x, y, 114, 18, mouseX, mouseY)) {
			int percentage = percentage(max, value);
			List<String> list = new ArrayList<>();
			list.add("" + TextFormatting.GOLD + value + "/" + max + suffix);
			list.add(getPercentageColour(percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Full");

			if (value > max) {
				list.add(TextFormatting.GRAY + "Yo this is storing more than it should be able to");
				list.add(TextFormatting.GRAY + "prolly a bug");
				list.add(TextFormatting.GRAY + "pls report and tell how tf you did this");
			}
			net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(list, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1, gui.field_146297_k.field_71466_p);
			GlStateManager.func_179140_f();
			GlStateManager.func_179131_c(1, 1, 1, 1);
		}
	}

	public void drawBigHeatBar(GuiBase gui, int x, int y, int value, int max, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(x, y, 0, 218, 114, 18);
		if (value != 0) {
			int j = (int) ((double) value / (double) max * 106);
			if (j < 0)
				j = 0;
			gui.func_73729_b(x + 4, y + 4, 0, 246, j, 10);
			gui.drawCentredString(value + " Heat", y + 5, 0xFFFFFF, layer);

		}
	}

	public void drawMultiblockMissingBar(GuiBase gui, GuiBase.Layer layer) {
		int x = 0;
		int y = 4;
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		GlStateManager.func_179140_f();
		GlStateManager.func_179097_i();
		GlStateManager.func_179135_a(true, true, true, false);
		GuiUtils.drawGradientRect(0, x, y, x + 176, y + 20, 0x000000, 0xC0000000);
		GuiUtils.drawGradientRect(0, x, y + 20, x + 176, y + 20 + 48, 0xC0000000, 0xC0000000);
		GuiUtils.drawGradientRect(0, x, y + 68, x + 176, y + 70 + 20, 0xC0000000, 0x00000000);
		GlStateManager.func_179135_a(true, true, true, true);
		GlStateManager.func_179126_j();
		gui.drawCentredString(I18n.func_74838_a("techreborn.message.missingmultiblock"), 43, 0xFFFFFF, layer);
	}

	public void drawBigBlueBar(GuiBase gui, int x, int y, int value, int max, int mouseX, int mouseY, GuiBase.Layer layer) {
		drawBigBlueBar(gui, x, y, value, max, mouseX, mouseY, "", layer);
	}

	public void drawSelectedStack(GuiBase gui, int x, int y) {
		Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(x - 4, y - 4, 202, 44, 24, 24);
	}

	public void drawBurnBar(GuiBase gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
		if (layer == GuiBase.Layer.BACKGROUND) {
			x += gui.field_147003_i;
			y += gui.field_147009_r;
		}
		if (layer == GuiBase.Layer.FOREGROUND) {
			mouseX -= gui.field_147003_i;
			mouseY -= gui.field_147009_r;
		}

		gui.field_146297_k.func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(x, y, 171, 84, 13, 13);
		int j = 13 - (int) ((double) progress / (double) maxProgress * 13);
		if (j > 0) {
			gui.func_73729_b(x, y + j, 171, 70 + j, 13, 13 - j);

		}
		if (isInRect(x, y, 12, 12, mouseX, mouseY)) {
			int percentage = percentage(maxProgress, progress);
			List<String> list = new ArrayList<>();
			list.add(getPercentageColour(percentage) + "" + percentage + "%");
			net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(list, mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, -1, gui.field_146297_k.field_71466_p);
			GlStateManager.func_179140_f();
			GlStateManager.func_179131_c(1, 1, 1, 1);
		}
	}

	public void drawSlot(GuiScreen gui, int posX, int posY) {
		Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(posX, posY, 150, 0, 18, 18);
	}

	public void drawOutputSlot(GuiScreen gui, int posX, int posY) {
		Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_SHEET);
		gui.func_73729_b(posX, posY, 150, 18, 26, 26);
	}

	public int getScaledBurnTime(int scale, int burnTime, int totalBurnTime) {
		return (int) (((float) burnTime / (float) totalBurnTime) * scale);
	}

	public TextFormatting getPercentageColour(int percentage) {
		if (percentage <= 10) {
			return TextFormatting.RED;
		} else if (percentage >= 75) {
			return TextFormatting.GREEN;
		} else {
			return TextFormatting.YELLOW;
		}
	}

	public int percentage(int MaxValue, int CurrentValue) {
		if (CurrentValue == 0)
			return 0;
		return (int) ((CurrentValue * 100.0f) / MaxValue);
	}

	public enum ProgressDirection {
		RIGHT(84, 151, 100, 151, 16, 10), LEFT(100, 161, 84, 161, 16, 10)/*, DOWN(104, 171, 114, 171, 10, 16), UP(84, 171, 94, 171, 10, 16)*/;
		public int x;
		public int y;
		public int xActive;
		public int yActive;
		public int width;
		public int height;

		ProgressDirection(int x, int y, int xActive, int yActive, int width, int height) {
			this.x = x;
			this.y = y;
			this.xActive = xActive;
			this.yActive = yActive;
			this.width = width;
			this.height = height;
		}
	}
}
