package techreborn.client.gui.widget;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

import java.util.ArrayList;

public abstract class GuiWidget<T extends Container> extends GuiContainer {

	public static final LanguageMap translate = ObfuscationReflectionHelper.getPrivateValue(LanguageMap.class, null, 2);

	private final ArrayList<Widget> widgets = new ArrayList<>();
	private final ResourceLocation background;

	public GuiWidget(T inventorySlotsIn, ResourceLocation background, int xSize, int ySize) {
		super(inventorySlotsIn);
		this.field_146999_f = xSize;
		this.field_147000_g = ySize;
		this.background = background;
	}

	public T getContainer() {
		return (T) field_147002_h;
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		widgets.clear();
		initWidgets();
	}

	public void addWidget(Widget widget) {
		widgets.add(widget);
	}

	public void removeWidget(Widget widget) {
		widgets.remove(widget);
	}

	public abstract void initWidgets();

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
		field_146297_k.func_110434_K().func_110577_a(background);
		int x = (this.field_146294_l - this.field_146999_f) / 2;
		int y = (this.field_146295_m - this.field_147000_g) / 2;
		this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY) {
		int x = (this.field_146294_l - this.field_146999_f) / 2;
		int y = (this.field_146295_m - this.field_147000_g) / 2;
		String name = translate.func_74805_b("tile.techreborn.industrialgrinder.name");

		field_146289_q.func_78276_b(name, field_146999_f / 2 - field_146289_q.func_78256_a(name) / 2, 6, 4210752);
		field_146289_q.func_78276_b(translate.func_74805_b("container.inventory"), 8, field_147000_g - 94, 4210752);

		for (Widget widget : widgets)
			widget.drawWidget(this, x, y, mouseX, mouseY);
	}

	public FontRenderer getFontRenderer() {
		return field_146289_q;
	}

}
