package techreborn.client.render.parts;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.*;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import reborncore.client.models.BakedModelUtils;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.parts.powerCables.CableMultipart;
import techreborn.parts.powerCables.EnumCableType;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RenderCablePart implements IBakedModel {

	EnumCableType type;
	private FaceBakery faceBakery = new FaceBakery();
	private TextureAtlasSprite texture;

	public RenderCablePart(EnumCableType type) {
		texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(type.textureName);
		this.type = type;
	}

	@Override
	public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
		type = blockState.func_177229_b(CableMultipart.TYPE);
		texture = Minecraft.func_71410_x().func_147117_R().func_110572_b(type.textureName);
		ArrayList<BakedQuad> list = new ArrayList<>();
		BlockFaceUV uv = new BlockFaceUV(new float[] { 0.0F, 0.0F, 16.0F, 16.0F }, 0);
		BlockPartFace face = new BlockPartFace(null, 0, "", uv);
		double thickness = type.cableThickness;
		double lastThickness = 16 - thickness;
		IExtendedBlockState state = (IExtendedBlockState) blockState;
		if (side != null) {
			return Collections.emptyList();
		}
		BakedModelUtils.addCubeToList(new Vecs3dCube(thickness, thickness, thickness, lastThickness, lastThickness, lastThickness),
			list, face, ModelRotation.X0_Y0, texture, null, faceBakery);
		if (state != null) {
			if (state.getValue(CableMultipart.UP)) {
				BakedModelUtils.addCubeToList(new Vecs3dCube(thickness, lastThickness, thickness, lastThickness, 16.0, lastThickness),
					list, face, ModelRotation.X0_Y0, texture, EnumFacing.UP, faceBakery);
			}
			if (state.getValue(CableMultipart.DOWN)) {
				BakedModelUtils.addCubeToList(new Vecs3dCube(thickness, 0.0, thickness, lastThickness, thickness, lastThickness), list,
					face, ModelRotation.X0_Y0, texture, EnumFacing.DOWN, faceBakery);
			}
			if (state.getValue(CableMultipart.NORTH)) {
				BakedModelUtils.addCubeToList(new Vecs3dCube(0.0, thickness, thickness, thickness, lastThickness, lastThickness), list,
					face, ModelRotation.X0_Y90, texture, EnumFacing.NORTH, faceBakery);
			}
			if (state.getValue(CableMultipart.SOUTH)) {
				BakedModelUtils.addCubeToList(new Vecs3dCube(0.0, thickness, thickness, thickness, lastThickness, lastThickness),
					list, face, ModelRotation.X0_Y270, texture, EnumFacing.SOUTH, faceBakery);
			}
			if (state.getValue(CableMultipart.EAST)) {
				BakedModelUtils.addCubeToList(new Vecs3dCube(lastThickness, thickness, thickness, 16.0, lastThickness, lastThickness),
					list, face, ModelRotation.X0_Y0, texture, EnumFacing.EAST, faceBakery);
			}
			if (state.getValue(CableMultipart.WEST)) {
				BakedModelUtils.addCubeToList(new Vecs3dCube(0.0, thickness, thickness, thickness, lastThickness, lastThickness), list,
					face, ModelRotation.X0_Y0, texture, EnumFacing.WEST, faceBakery);
			}
		}
		return list;
	}

	@Override
	public boolean func_177555_b() {
		return true;
	}

	@Override
	public boolean func_177556_c() {
		return true;
	}

	@Override
	public boolean func_188618_c() {
		return false;
	}

	@Override
	public TextureAtlasSprite func_177554_e() {
		return texture;
	}

	@Override
	public ItemCameraTransforms func_177552_f() {
		return ItemCameraTransforms.field_178357_a;
	}

	@Override
	public ItemOverrideList func_188617_f() {
		return null;
	}
}
