package techreborn.init.recipes;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.recipe.machines.ExtractorRecipe;
import techreborn.init.ModBlocks;
import techreborn.items.DynamicCell;

import techreborn.init.recipes.RecipeMethods.Type;

/**
 * Created by Prospector
 */
public class ExtractorRecipes extends RecipeMethods {
	public static void init() {
		register(getStack(ModBlocks.RUBBER_SAPLING), false, getMaterial("rubber", Type.PART));
		register(getStack(ModBlocks.RUBBER_LOG), false, getMaterial("rubber", Type.PART));
		register(getStack(Items.field_151123_aH), getMaterial("rubber", 2, Type.PART));
		register(getMaterial("sap", Type.PART), getMaterial("rubber", 3, Type.PART));
		register(getStack(Blocks.field_150328_O), getStack(Items.field_151100_aR, 2, 1));
		register(getStack(Blocks.field_150327_N), getStack(Items.field_151100_aR, 2, 11));
		register(getStack(Blocks.field_150328_O, 1, 1), getStack(Items.field_151100_aR, 2, 12));
		register(getStack(Blocks.field_150328_O, 1, 2), getStack(Items.field_151100_aR, 2, 13));
		register(getStack(Blocks.field_150328_O, 1, 3), getStack(Items.field_151100_aR, 2, 7));
		register(getStack(Blocks.field_150328_O, 1, 4), getStack(Items.field_151100_aR, 2, 1));
		register(getStack(Blocks.field_150328_O, 1, 5), getStack(Items.field_151100_aR, 2, 14));
		register(getStack(Blocks.field_150328_O, 1, 6), getStack(Items.field_151100_aR, 2, 7));
		register(getStack(Blocks.field_150328_O, 1, 7), getStack(Items.field_151100_aR, 2, 9));
		register(getStack(Blocks.field_150328_O, 1, 8), getStack(Items.field_151100_aR, 2, 7));
		register(getStack(Blocks.field_150398_cm), getStack(Items.field_151100_aR, 4, 11));
		register(getStack(Blocks.field_150398_cm, 1, 1), getStack(Items.field_151100_aR, 4, 13));
		register(getStack(Blocks.field_150398_cm, 1, 4), getStack(Items.field_151100_aR, 4, 1));
		register(getStack(Blocks.field_150398_cm, 1, 5), getStack(Items.field_151100_aR, 4, 9));
		register(getStack(Blocks.field_150329_H, 1, 1), getStack(Items.field_151014_N));
		register(getStack(Blocks.field_150329_H, 1, 2), getStack(Items.field_151014_N));
		register(getStack(Blocks.field_150398_cm, 1, 2), getStack(Items.field_151014_N, 2));
		register(getStack(Blocks.field_150398_cm, 1, 3), getStack(Items.field_151014_N, 2));
		register(getStack(Blocks.field_150330_I, 1, 0), getStack(Items.field_151055_y));
		for (int i = 1; i < 15; i++)
			register(getStack(Blocks.field_150325_L, 1, i), getStack(Blocks.field_150325_L, 1, 0));
		for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
			register(DynamicCell.getCellWithFluid(fluid), DynamicCell.getEmptyCell(1));
		}
	}

	static void register(ItemStack input, ItemStack output) {
		register(input, true, output);
	}

	static void register(ItemStack input, boolean oreDict, ItemStack output) {
		RecipeHandler.addRecipe(new ExtractorRecipe(input, output, 400, 2, oreDict));
	}
}
