package techreborn.init.recipes;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.recipe.machines.CentrifugeRecipe;
import techreborn.init.ModBlocks;
import techreborn.items.DynamicCell;

import java.security.InvalidParameterException;

import techreborn.init.recipes.RecipeMethods.Type;

/**
 * Created by Prospector
 */
public class IndustrialCentrifugeRecipes extends RecipeMethods {
	public static void init() {
		register(getStack(Items.field_151064_bs), 500, getStack(Items.field_151065_br), getStack(Items.field_151123_aH));
		register(getStack(Blocks.field_150346_d, 16), 2500, getStack(Blocks.field_150354_m, 8), getStack(Items.field_151119_aD), getStack(Blocks.field_150351_n, 2));
		register(getStack(Blocks.field_150346_d, 16), 2500, getStack(Blocks.field_150354_m, 8), getStack(Items.field_151119_aD), getStack(Blocks.field_150351_n, 2), getStack(Items.field_151014_N, 4));
		register(getStack(Blocks.field_150391_bh, 8), 1640, getStack(Blocks.field_150354_m, 4), getStack(Items.field_151119_aD), getStack(Blocks.field_150338_P, 2), getStack(Blocks.field_150337_Q, 2));
		register(getStack(Items.field_151153_ao), 10000, getStack(Items.field_151043_k, 6), getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151153_ao, 1, 1), 10000, getStack(Items.field_151043_k, 64), getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151150_bK), 10000, getStack(Items.field_151074_bl, 6), getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151060_bw, 8), 10000, getStack(Items.field_151074_bl, 6), getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151034_e, 32), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151009_A, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151025_P, 64), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151147_al, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151157_am, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151082_bd, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151083_be, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151076_bf, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151077_bg, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_179561_bm, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_179557_bn, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_179558_bo, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_179559_bp, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151115_aP, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_179566_aV, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151127_ba, 64), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Blocks.field_150423_aK, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151078_bh, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151070_bp, 32), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151172_bF, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151174_bG, 16), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151170_bI, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151168_bH, 24), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_185164_cV, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151106_aX, 64), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Blocks.field_150420_aW, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Blocks.field_150419_aX, 12), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Blocks.field_150338_P, 32), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Blocks.field_150337_Q, 32), 5000, getMaterial("methane", Type.CELL));
		register(getStack(Items.field_151075_bm, 32), 5000, getMaterial("methane", Type.CELL));
		register(getMaterial("sap", 4, Type.PART), 1300, getMaterial("rubber", 14, Type.PART));
		register(getStack(Blocks.field_150425_aM, 16), 2500, getStack(Blocks.field_150354_m, 10), getMaterial("saltpeter", 4, Type.DUST), getMaterial("coal", Type.DUST), getMaterial("oil", Type.CELL));
		register(getMaterial("lava", 16, Type.CELL), 15000, getMaterial("tin", 18, Type.INGOT), getMaterial("copper", 4, Type.INGOT), getMaterial("electrum", Type.INGOT), getMaterial("tungsten", Type.SMALL_DUST));
		register(getMaterial("bronze", Type.DUST), 1500, getMaterial("copper", 6, Type.SMALL_DUST), getMaterial("tin", 2, Type.SMALL_DUST));
		register(getMaterial("iron", 2, Type.DUST), 1500, getMaterial("tin", Type.SMALL_DUST), getMaterial("nickel", Type.SMALL_DUST));
		register(getMaterial("silver", 2, Type.DUST), 2400, getMaterial("lead", Type.SMALL_DUST));
		register(getMaterial("lead", 2, Type.DUST), 2400, getMaterial("silver", Type.SMALL_DUST));
		register(getMaterial("tin", 2, Type.DUST), 210, getMaterial("zinc", Type.SMALL_DUST), getMaterial("iron", Type.SMALL_DUST));
		register(getMaterial("electrum", Type.DUST), 960, getMaterial("gold", 2, Type.SMALL_DUST), getMaterial("silver", 2, Type.SMALL_DUST));
		register(getMaterial("zinc", Type.DUST), 1040, getMaterial("tin", Type.SMALL_DUST));
		register(getMaterial("brass", Type.DUST), 1500, getMaterial("copper", 3, Type.SMALL_DUST), getMaterial("zinc", Type.SMALL_DUST));
		register(getMaterial("platinum", 2, Type.DUST), 3000, getMaterial("iridium", 2, Type.NUGGET), getMaterial("nickel", Type.SMALL_DUST));
		register(getMaterial("nickel", 3, Type.DUST), 3440, getMaterial("iron", Type.SMALL_DUST), getMaterial("gold", Type.SMALL_DUST), getMaterial("copper", Type.SMALL_DUST));
		register(getMaterial("gold", 3, Type.DUST), 2400, getMaterial("copper", Type.SMALL_DUST), getMaterial("nickel", Type.SMALL_DUST));
		register(getMaterial("copper", 3, Type.DUST), 2400, getMaterial("gold", Type.SMALL_DUST), getMaterial("nickel", Type.SMALL_DUST));
		register(getStack(ModBlocks.RUBBER_LOG, 16), 5000, false, getMaterial("sap", 8, Type.PART), getMaterial("methane", Type.CELL), getMaterial("carbon", 4, Type.CELL));
		register(getStack(Items.field_151137_ax, 32), 22000, getMaterial("silicon", 3, Type.CELL), getMaterial("pyrite", 16, Type.DUST), getMaterial("ruby", 3, Type.DUST), getMaterial("mercury", 10, Type.CELL));
		register(getStack(Items.field_151114_aO, 16), 25000, getStack(Items.field_151137_ax, 8), getMaterial("sulfur", 8, Type.DUST), getMaterial("helium", Type.CELL));
		register(getStack(Items.field_151100_aR, 4, 4), 1500, false, getMaterial("lazurite", 3, Type.DUST), getMaterial("pyrite", Type.SMALL_DUST), getMaterial("calcite", Type.SMALL_DUST), getMaterial("sodalite", 2, Type.SMALL_DUST));
		register(getMaterial("ender_eye", 2, Type.DUST), 1840, getMaterial("ender_pearl", Type.DUST), getStack(Items.field_151065_br));
		register(getMaterial("netherrack", 16, Type.DUST), 2400, getStack(Items.field_151137_ax), getMaterial("sulfur", 4, Type.DUST), getMaterial("coal", Type.DUST), getStack(Items.field_151074_bl));
		register(getMaterial("endstone", 16, Type.DUST), 4800, getMaterial("helium3", Type.CELL), getMaterial("helium", Type.CELL), getMaterial("tungsten", Type.SMALL_DUST), getStack(Blocks.field_150354_m, 12));
		register(getMaterial("red_garnet", 16, Type.DUST), 3000, getMaterial("pyrope", 3, Type.DUST), getMaterial("almandine", 5, Type.DUST), getMaterial("spessartine", 8, Type.DUST));
		register(getMaterial("yellow_garnet", 16, Type.DUST), 3500, getMaterial("andradite", 5, Type.DUST), getMaterial("grossular", 8, Type.DUST), getMaterial("uvarovite", 3, Type.DUST));
		register(getMaterial("dark_ashes", 2, Type.DUST), 240, getMaterial("ashes", 2, Type.DUST));
		register(getMaterial("marble", 8, Type.DUST), 1040, getMaterial("magnesium", Type.DUST), getMaterial("calcite", 7, Type.DUST));
		register(getMaterial("basalt", 16, Type.DUST), 2040, getMaterial("peridot", Type.DUST), getMaterial("calcite", 3, Type.DUST), getMaterial("flint", 8, Type.DUST), getMaterial("dark_ashes", 4, Type.DUST));
		register(getMaterial("hydrogen", 4, Type.CELL), 3000, getMaterial("deuterium", Type.CELL));
		register(getMaterial("deuterium", 4, Type.CELL), 3000, getMaterial("tritium", Type.CELL));
		register(getMaterial("helium", 16, Type.CELL), 10000, getMaterial("helium3", Type.CELL));
		register(getMaterial("calciumcarbonate", Type.CELL), 40, getMaterial("calcite", Type.DUST));
		register(getMaterial("sulfur", Type.CELL), 40, getMaterial("sulfur", Type.DUST));
	}

	static void register(ItemStack input, int ticks, boolean oreDict, ItemStack... outputs) {
		ItemStack output1;
		ItemStack output2 = null;
		ItemStack output3 = null;
		ItemStack output4 = null;

		if (outputs.length == 3) {
			output1 = outputs[0];
			output2 = outputs[1];
			output3 = outputs[2];
		} else if (outputs.length == 2) {
			output1 = outputs[0];
			output2 = outputs[1];
		} else if (outputs.length == 1) {
			output1 = outputs[0];
		} else if (outputs.length == 4) {
			output1 = outputs[0];
			output2 = outputs[1];
			output3 = outputs[2];
			output4 = outputs[3];
		} else {
			throw new InvalidParameterException("Invalid industrial centrifuge outputs: " + outputs);
		}

		int cellCount = 0;
		for (ItemStack stack : outputs) {
			if (stack.func_77973_b() instanceof DynamicCell) {
				cellCount += stack.field_77994_a;
			}

		}

		if (input.func_77973_b() instanceof DynamicCell) {
			int inputCount = input.field_77994_a;
			if (cellCount < inputCount) {
				if (output2 == null) {
					output2 = DynamicCell.getEmptyCell(inputCount - cellCount);
				} else if (output3 == null) {
					output3 = DynamicCell.getEmptyCell(inputCount - cellCount);
				} else if (output4 == null) {
					output4 = DynamicCell.getEmptyCell(inputCount - cellCount);
				}
			}
			cellCount -= inputCount;

		}

		if (cellCount < 0) {
			cellCount = 0;
		}
		ItemStack cells = null;
		if (cellCount > 0) {
			if (cellCount > 64) {
				throw new InvalidParameterException("Invalid industrial centrifuge outputs: " + outputs + "(Recipe requires > 64 cells)");
			}
			cells = DynamicCell.getEmptyCell(cellCount);
		}
		RecipeHandler.addRecipe(new CentrifugeRecipe(input, cells, output1, output2, output3, output4, ticks, 5, oreDict));
	}

	static void register(ItemStack input, int ticks, ItemStack... outputs) {
		register(input, ticks, true, outputs);
	}
}
